/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="relics", value={Dist.CLIENT})
public class ClientScheduler {
    private static final Deque<ScheduledTask> allTasksQueue = new LinkedList<ScheduledTask>();
    private static final List<ScheduledTask> allTasks = new ArrayList<ScheduledTask>();

    public static ScheduledTask schedule(int ticks, Runnable task) {
        ScheduledTask scheduled = new ScheduledTask(ticks, task);
        allTasksQueue.add(scheduled);
        return scheduled;
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        while (!allTasksQueue.isEmpty()) {
            ScheduledTask task = allTasksQueue.removeFirst();
            allTasks.add(task);
        }
        allTasks.removeIf(ScheduledTask::tick);
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        allTasks.clear();
        allTasksQueue.clear();
    }

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        allTasks.clear();
        allTasksQueue.clear();
    }

    public static class ScheduledTask {
        private int ticks;
        private final Runnable task;
        private boolean cancelled;

        public ScheduledTask(int ticks, Runnable task) {
            this.ticks = ticks;
            this.task = task;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean tick() {
            if (this.cancelled) {
                return true;
            }
            if (this.ticks == 0) {
                this.task.run();
            }
            return --this.ticks < 0;
        }
    }
}

