/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import it.hurts.sskirillss.relics.api.relics.IRelicItem;
import java.awt.Color;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FlawlessUtils {
    public static Color getColor(LivingEntity entity, ItemStack stack, Color color) {
        IRelicItem relic;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).isRelicFlawless(entity, stack)) {
            return color;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float baseHue = 0.125f;
        float minHue = 0.1f;
        float maxHue = 0.16f;
        float blended = baseHue + (hsb[0] - baseHue) * 0.25f;
        float offset = (hsb[0] - baseHue) * 0.1f;
        float goldenHue = blended + offset;
        if (hsb[0] > 0.25f && hsb[0] < 0.45f) {
            goldenHue -= 0.01f;
        }
        goldenHue = Math.max(minHue, Math.min(maxHue, goldenHue));
        float saturation = Math.min(1.0f, Math.max(0.0f, 0.55f + 0.35f * hsb[1]));
        float brightness = Math.min(1.0f, Math.max(0.0f, 0.72f + 0.28f * hsb[2]));
        return Color.getHSBColor(goldenHue, saturation, brightness);
    }

    public static ResourceLocation getTexture(LivingEntity entity, ItemStack stack, ResourceLocation location) {
        boolean isFlawless = ((IRelicItem)stack.getItem()).isRelicFlawless(entity, stack);
        return isFlawless ? ResourceLocation.parse((String)location.toString().replaceFirst("\\.png$", "_flawless.png")) : location;
    }
}

