/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import net.minecraft.util.RandomSource;

public class MathUtils {
    public static float randomFloat(RandomSource random) {
        return -1.0f + 2.0f * random.nextFloat();
    }

    public static float randomBetween(RandomSource random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double randomBetween(RandomSource random, double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static int randomBetween(RandomSource random, int min, int max) {
        return (int)Math.round(MathUtils.randomBetween(random, (double)min, (double)max));
    }

    public static double round(double value, int steps) {
        double multiplier = Math.pow(10.0, steps);
        return (double)Math.round(value * multiplier) / multiplier;
    }

    @Deprecated(forRemoval=true)
    public static int multicast(RandomSource random, double chance, double chanceMultiplier) {
        return random.nextDouble() <= chance ? MathUtils.multicast(random, chance * chanceMultiplier, chanceMultiplier) + 1 : 0;
    }

    public static int multicast(RandomSource random, double chance, int maxIterations) {
        int count;
        for (count = 0; count < maxIterations && random.nextDouble() <= chance; ++count) {
        }
        return count;
    }

    public static int multicast(RandomSource random, double chance) {
        return MathUtils.multicast(random, chance, 100);
    }

    public static String formatTime(long totalSeconds) {
        int first;
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        int SECONDS_PER_DAY = 86400;
        long days = totalSeconds / 86400L;
        long rem = totalSeconds % 86400L;
        long hours = rem / 3600L;
        long minutes = (rem %= 3600L) / 60L;
        long seconds = rem % 60L;
        long[] parts = new long[]{days, hours, minutes, seconds};
        for (first = 0; first < parts.length && parts[first] == 0L; ++first) {
        }
        if (first == parts.length) {
            return "0";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = first; i < parts.length; ++i) {
            if (i > first) {
                builder.append(':');
            }
            builder.append(String.format("%02d", parts[i]));
        }
        return builder.toString();
    }
}

