/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WorldUtils {
    public static List<BlockPos> getBlockSphere(BlockPos center, double radius) {
        ArrayList<BlockPos> sphere = new ArrayList<BlockPos>((int)Math.pow(radius, 3.0));
        int i = -((int)radius);
        while ((double)i <= radius) {
            float r1 = Mth.sqrt((float)((float)(radius * radius - (double)(i * i))));
            int j = -((int)r1);
            while ((float)j <= r1) {
                float r2 = Mth.sqrt((float)((float)(radius * radius - (double)(i * i) - (double)(j * j))));
                int k = -((int)r2);
                while ((float)k <= r2) {
                    sphere.add(center.offset(i, j, k));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return sphere;
    }

    public static double getGroundHeight(Entity entity, Vec3 position, int iterations) {
        Level level = entity.level();
        BlockHitResult result = level.clip(new ClipContext(position, position.add(0.0, (double)(-iterations), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, entity));
        if (result.getType() == HitResult.Type.BLOCK) {
            return result.getLocation().y();
        }
        return -level.getMaxBuildHeight();
    }

    public static int findSurfaceY(Level level, int x, int z, int centerY, int maxOffset) {
        BlockPos above;
        BlockPos pos;
        int y;
        int dy;
        for (dy = 0; dy <= maxOffset && (y = centerY - dy) >= level.getMinBuildHeight(); ++dy) {
            pos = new BlockPos(x, y, z);
            above = pos.above();
            if (level.isEmptyBlock(pos) || !level.isEmptyBlock(above)) continue;
            return y;
        }
        for (dy = 1; dy <= maxOffset && (y = centerY + dy) <= level.getMaxBuildHeight(); ++dy) {
            pos = new BlockPos(x, y, z);
            above = pos.above();
            if (level.isEmptyBlock(pos) || !level.isEmptyBlock(above)) continue;
            return y;
        }
        return centerY;
    }
}

