/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.lang3.tuple.Pair;

public class AnimationData {
    private final List<Pair<Integer, Integer>> frames = new ArrayList<Pair<Integer, Integer>>();

    public int getLength() {
        return this.frames.stream().mapToInt(Pair::getRight).sum();
    }

    @Deprecated(forRemoval=true)
    public Pair<Integer, Integer> getFrameByTime(long time) {
        long total = this.getLength();
        if (total == 0L) {
            return Pair.of((Object)0, (Object)0);
        }
        long rem = time % total;
        int size = this.frames.size();
        int idx = 0;
        while (rem >= 0L) {
            Pair<Integer, Integer> p = this.frames.get(idx);
            if ((rem -= (long)((Integer)p.getRight()).intValue()) < 0L) {
                return p;
            }
            idx = (idx + 1) % size;
        }
        return this.frames.getFirst();
    }

    public AnimationData frame(int index, int time) {
        this.frames.add((Pair<Integer, Integer>)Pair.of((Object)index, (Object)time));
        return this;
    }

    public static AnimationData construct(int texHeight, int patternHeight, int frameTime) {
        AnimationData data = new AnimationData();
        int count = texHeight / patternHeight;
        for (int i = 0; i < count; ++i) {
            data.frame(i, frameTime);
        }
        return data;
    }

    public static AnimationData fromMcmeta(Path path) {
        AnimationData animationData;
        block8: {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                animationData = AnimationData.fromMcmeta(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new AnimationData();
                }
            }
            in.close();
        }
        return animationData;
    }

    public static AnimationData fromMcmeta(ResourceLocation location) {
        AnimationData animationData;
        block9: {
            ResourceManager manager = Minecraft.getInstance().getResourceManager();
            Optional opt = manager.getResource(location);
            if (opt.isEmpty()) {
                return new AnimationData();
            }
            InputStream in = ((Resource)opt.get()).open();
            try {
                animationData = AnimationData.fromMcmeta(in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new AnimationData();
                }
            }
            in.close();
        }
        return animationData;
    }

    private static AnimationData fromMcmeta(InputStream input) {
        int defTime;
        JsonObject anim;
        InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
        JsonElement rootElem = JsonParser.parseReader((Reader)reader);
        if (!rootElem.isJsonObject()) {
            return new AnimationData();
        }
        JsonObject obj = rootElem.getAsJsonObject();
        JsonObject jsonObject = anim = obj.has("animation") && obj.get("animation").isJsonObject() ? obj.getAsJsonObject("animation") : null;
        if (anim == null) {
            return new AnimationData();
        }
        AnimationData data = new AnimationData();
        int n = defTime = anim.has("frametime") ? anim.get("frametime").getAsInt() : 1;
        if (anim.has("frames") && anim.get("frames").isJsonArray()) {
            JsonArray arr = anim.getAsJsonArray("frames");
            for (JsonElement e : arr) {
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                    data.frame(e.getAsInt(), defTime);
                    continue;
                }
                if (!e.isJsonObject()) continue;
                JsonObject o = e.getAsJsonObject();
                int idx = o.has("index") ? o.get("index").getAsInt() : 0;
                int t = o.has("time") ? o.get("time").getAsInt() : defTime;
                data.frame(idx, t);
            }
        }
        return data;
    }

    public static AnimationData builder() {
        return new AnimationData();
    }

    @Generated
    public AnimationData() {
    }

    @Generated
    public List<Pair<Integer, Integer>> getFrames() {
        return this.frames;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnimationData)) {
            return false;
        }
        AnimationData other = (AnimationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Pair<Integer, Integer>> this$frames = this.getFrames();
        List<Pair<Integer, Integer>> other$frames = other.getFrames();
        return !(this$frames == null ? other$frames != null : !((Object)this$frames).equals(other$frames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnimationData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Pair<Integer, Integer>> $frames = this.getFrames();
        result = result * 59 + ($frames == null ? 43 : ((Object)$frames).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnimationData(frames=" + String.valueOf(this.getFrames()) + ")";
    }
}

