/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.serialization.DataResult;
import io.wispforest.owo.Owo;
import io.wispforest.owo.util.StackTraceSupplier;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DataResult.class}, remap=false)
public interface DataResultMixin {
    @Inject(method={"error(Ljava/util/function/Supplier;)Lcom/mojang/serialization/DataResult;", "error(Ljava/util/function/Supplier;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "error(Ljava/util/function/Supplier;Lcom/mojang/serialization/Lifecycle;)Lcom/mojang/serialization/DataResult;", "error(Ljava/util/function/Supplier;Ljava/lang/Object;Lcom/mojang/serialization/Lifecycle;)Lcom/mojang/serialization/DataResult;"}, at={@At(value="HEAD")}, remap=false)
    private static <R> void wrapMessageWithStacktrace(CallbackInfoReturnable<Optional<DataResult.Error<R>>> cir, @Local(argsOnly=true) LocalRef<Supplier<String>> messageSupplier) {
        if (!Owo.DEBUG) {
            return;
        }
        Supplier ogSupplier = (Supplier)messageSupplier.get();
        Class<?> ogClass = ogSupplier.getClass();
        if (ogSupplier instanceof StackTraceSupplier) {
            return;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (ogClass.isSynthetic()) {
            try {
                for (Field field : ogClass.getDeclaredFields()) {
                    if (!Throwable.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    Object object = field.get(ogSupplier);
                    if (object instanceof Throwable) {
                        Throwable e = (Throwable)object;
                        stackTrace = (StackTraceElement[])e.getStackTrace().clone();
                    }
                    break;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        messageSupplier.set((Object)new StackTraceSupplier(stackTrace, ogSupplier));
    }

    @Mixin(value={DataResult.Error.class}, remap=false)
    public static abstract class DataResultErrorMixin<R> {
        @Shadow(remap=false)
        public abstract Supplier<String> messageSupplier();

        @Inject(method={"getOrThrow", "getPartialOrThrow"}, at={@At(value="HEAD")}, remap=false)
        private <E extends Throwable> void addStackTraceToException(CallbackInfoReturnable<R> cir, @Local(argsOnly=true) LocalRef<Function<String, E>> exceptionSupplier) {
            Function funcToWrap = (Function)exceptionSupplier.get();
            exceptionSupplier.set(s -> {
                Throwable exception = (Throwable)funcToWrap.apply(s);
                Supplier<String> patt0$temp = this.messageSupplier();
                if (patt0$temp instanceof StackTraceSupplier) {
                    StackTraceSupplier stackTraceSupplier = (StackTraceSupplier)patt0$temp;
                    exception.setStackTrace(stackTraceSupplier.stackTrace());
                }
                return exception;
            });
        }
    }
}

