/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Preconditions;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.util.EventHelper;
import com.mrcrayfish.controllable.client.util.InputHelper;
import com.mrcrayfish.controllable.event.Value;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.ITickEvent;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;

public class CameraHandler {
    private static CameraHandler instance;
    private float pitchDelta;
    private float yawDelta;
    private boolean initialized;

    @ApiStatus.Internal
    public CameraHandler() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Only one instance of CameraHandler is allowed");
        instance = this;
    }

    @ApiStatus.Internal
    public void registerEvents() {
        if (!this.initialized) {
            TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)this::updateRotationDelta));
            TickEvents.START_RENDER.register((IFrameworkEvent)((ITickEvent.StartRender)this::updateCamera));
            this.initialized = true;
        }
    }

    private void updateRotationDelta() {
        this.yawDelta = 0.0f;
        this.pitchDelta = 0.0f;
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null || mc.player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        float thumbstickX = InputHelper.getCombinedPressedValue(controller, ButtonBindings.LOOK_LEFT, ButtonBindings.LOOK_RIGHT);
        float thumbstickY = InputHelper.getCombinedPressedValue(controller, ButtonBindings.LOOK_UP, ButtonBindings.LOOK_DOWN);
        if (thumbstickX * thumbstickX > 0.0f || thumbstickY * thumbstickY > 0.0f) {
            Value<Float> pitchSpeed;
            float spyglassSensitivity;
            float pitchSensitivity = ((Double)Config.CLIENT.options.pitchSensitivity.get()).floatValue();
            float yawSensitivity = ((Double)Config.CLIENT.options.yawSensitivity.get()).floatValue();
            float rotationSpeed = ((Double)Config.CLIENT.options.rotationSpeed.get()).floatValue();
            Value<Float> yawSpeed = new Value<Float>(Float.valueOf(rotationSpeed * yawSensitivity * (spyglassSensitivity = mc.player.isScoping() ? ((Double)Config.CLIENT.options.spyglassSensitivity.get()).floatValue() : 1.0f)));
            if (!EventHelper.postUpdateCameraEvent(yawSpeed, pitchSpeed = new Value<Float>(Float.valueOf(rotationSpeed * pitchSensitivity * spyglassSensitivity)))) {
                if (thumbstickX * thumbstickX > 0.0f) {
                    this.yawDelta = yawSpeed.get().floatValue() * thumbstickX;
                }
                if (thumbstickY * thumbstickY > 0.0f) {
                    this.pitchDelta = pitchSpeed.get().floatValue() * thumbstickY;
                }
            }
            controller.updateInputTime();
        }
    }

    private void updateCamera(DeltaTracker tracker) {
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen != null) {
            return;
        }
        if (this.yawDelta == 0.0f && this.pitchDelta == 0.0f) {
            return;
        }
        float elapsedTicks = tracker.getGameTimeDeltaTicks();
        if (!Controllable.getRadialMenu().isVisible()) {
            double elapsedDeltaYaw = this.yawDelta * elapsedTicks;
            double elapsedDeltaPitch = this.pitchDelta * elapsedTicks;
            mc.player.turn(elapsedDeltaYaw *= (double)((Boolean)Config.CLIENT.options.invertRotation.get() != false ? -1 : 1), elapsedDeltaPitch *= (double)((Boolean)Config.CLIENT.options.invertLook.get() != false ? -1 : 1));
        }
    }
}

