/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.screens.SettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ControllerButton;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.ScreenEvents;
import com.mrcrayfish.framework.event.IScreenEvent;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ControllerEvents {
    private static boolean released = false;

    public static void init() {
        ScreenEvents.INIT.register((IFrameworkEvent)((IScreenEvent.Init)ControllerEvents::onScreenInit));
        ScreenEvents.MODIFY_WIDGETS.register((IFrameworkEvent)((IScreenEvent.ModifyWidgets)ControllerEvents::onModifyScreenWidgets));
    }

    private static void onScreenInit(Screen screen) {
        ButtonBinding.resetButtonStates();
        if (!released) {
            released = true;
            Controller controller = Controllable.getController();
            if (controller != null && controller.isBeingUsed()) {
                Minecraft mc = Minecraft.getInstance();
                if (mc.gameMode != null && mc.player != null && mc.player.isUsingItem()) {
                    mc.gameMode.releaseUsingItem((Player)mc.player);
                }
            }
        }
        released = false;
    }

    private static void onModifyScreenWidgets(Screen screen, List<AbstractWidget> widgets, Consumer<AbstractWidget> add, Consumer<AbstractWidget> remove) {
        if (screen instanceof OptionsScreen) {
            Optional<AbstractWidget> btn = widgets.stream().filter(widget -> {
                Button button;
                return widget instanceof Button && (button = (Button)widget).getMessage().equals((Object)Component.translatable((String)"options.controls"));
            }).findFirst();
            btn.ifPresent(widget -> add.accept((AbstractWidget)new ControllerButton((AbstractWidget)widget, button -> Minecraft.getInstance().setScreen((Screen)new SettingsScreen(screen)))));
        }
    }
}

