/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.VirtualCursor;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.binding.handlers.ButtonHandler;
import com.mrcrayfish.controllable.client.binding.handlers.action.BindingMovementInput;
import com.mrcrayfish.controllable.client.binding.handlers.action.BindingOnRender;
import com.mrcrayfish.controllable.client.binding.handlers.action.BindingOnTick;
import com.mrcrayfish.controllable.client.binding.handlers.action.BindingPressed;
import com.mrcrayfish.controllable.client.binding.handlers.action.BindingReleased;
import com.mrcrayfish.controllable.client.binding.handlers.action.context.Context;
import com.mrcrayfish.controllable.client.binding.handlers.action.context.MovementInputContext;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.ListEntryNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.ListWidgetNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.Navigatable;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.SkipItem;
import com.mrcrayfish.controllable.client.gui.navigation.SlotNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.WidgetNavigationPoint;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.settings.AnalogMovement;
import com.mrcrayfish.controllable.client.settings.Thumbstick;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.EventHelper;
import com.mrcrayfish.controllable.client.util.InputHelper;
import com.mrcrayfish.controllable.client.util.MouseHooks;
import com.mrcrayfish.controllable.event.ControllerEvents;
import com.mrcrayfish.controllable.integration.EmiSupport;
import com.mrcrayfish.controllable.integration.JeiSupport;
import com.mrcrayfish.controllable.integration.ReiSupport;
import com.mrcrayfish.controllable.mixin.client.OverlayRecipeComponentAccessor;
import com.mrcrayfish.controllable.mixin.client.RecipeBookComponentAccessor;
import com.mrcrayfish.controllable.mixin.client.RecipeBookPageAccessor;
import com.mrcrayfish.controllable.platform.ClientServices;
import com.mrcrayfish.framework.api.event.ClientEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IClientEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.client.gui.screens.recipebook.OverlayRecipeComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;

public class InputHandler {
    private static InputHandler instance;
    private final Multimap<BindingOnTick.TickPhase, PriorityHandler<BindingOnTick>> activeTickHandlers = TreeMultimap.create();
    private final Multimap<BindingOnRender.RenderPhase, PriorityHandler<BindingOnRender>> activeRenderHandlers = TreeMultimap.create();
    private final Set<PriorityHandler<BindingMovementInput>> activeMovementInputHandlers = new TreeSet<PriorityHandler<BindingMovementInput>>();
    @Nullable
    private ButtonBinding activeVirtualBinding;
    private boolean initialized;

    @ApiStatus.Internal
    public InputHandler() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Only one instance of InputHandler is allowed");
        instance = this;
    }

    @ApiStatus.Internal
    public void registerEvents() {
        if (!this.initialized) {
            TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)this::onStartClickTick));
            TickEvents.END_CLIENT.register((IFrameworkEvent)((ITickEvent.EndClient)this::onEndClickTick));
            TickEvents.START_PLAYER.register((IFrameworkEvent)((ITickEvent.StartPlayer)this::onStartPlayerTick));
            TickEvents.END_PLAYER.register((IFrameworkEvent)((ITickEvent.EndPlayer)this::onEndPlayerTick));
            ClientEvents.PLAYER_INPUT_UPDATE.register((IFrameworkEvent)((IClientEvent.PlayerInputUpdate)this::updateInput));
            this.initialized = true;
        }
    }

    @Nullable
    public ButtonBinding getActiveVirtualBinding() {
        return this.activeVirtualBinding;
    }

    @ApiStatus.Internal
    public void handleButtonInput(Controller controller, int button, boolean state) {
        if (controller == null) {
            return;
        }
        controller.updateInputTime();
        if (state) {
            for (ButtonBinding binding : Controllable.getBindingRegistry().getBindingsForButton(button)) {
                if (this.handleBindingPressed(controller, binding, false)) break;
            }
        } else {
            for (ButtonBinding binding : Controllable.getBindingRegistry().getBindingsForButton(button)) {
                ButtonHandler handler = binding.getHandler();
                if (!(handler instanceof BindingPressed) || !binding.isButtonDown()) continue;
                ButtonBinding.setButtonState(binding, false);
                if (!(handler instanceof BindingReleased)) continue;
                BindingReleased released = (BindingReleased)((Object)handler);
                if (!binding.getContext().isActive()) continue;
                Minecraft mc = Minecraft.getInstance();
                Context context = new Context(binding, controller, mc, mc.player, (Level)mc.level, mc.screen, false);
                released.handleReleased(context);
                return;
            }
        }
    }

    @ApiStatus.Internal
    public boolean handleBindingPressed(Controller controller, ButtonBinding binding, boolean virtual) {
        Object tick;
        if (binding.isButtonDown()) {
            return true;
        }
        ButtonHandler handler = binding.getHandler();
        if (!(handler instanceof BindingPressed)) {
            return false;
        }
        BindingPressed pressed = (BindingPressed)((Object)handler);
        if (!binding.getContext().isActive()) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        Context context = new Context(binding, controller, mc, mc.player, (Level)mc.level, mc.screen, virtual);
        Optional<Runnable> action = pressed.createPressedHandler(context);
        if (action.isEmpty()) {
            return false;
        }
        ButtonBinding.setButtonState(binding, true);
        action.get().run();
        if (handler instanceof BindingOnTick) {
            tick = (BindingOnTick)((Object)handler);
            this.activeTickHandlers.put((Object)tick.phase(), new PriorityHandler<Object>(binding, tick));
        }
        if (handler instanceof BindingOnRender) {
            tick = (BindingOnRender)((Object)handler);
            this.activeRenderHandlers.put((Object)tick.phase(), new PriorityHandler<Object>(binding, tick));
        }
        if (handler instanceof BindingMovementInput) {
            BindingMovementInput input = (BindingMovementInput)((Object)handler);
            this.activeMovementInputHandlers.add(new PriorityHandler<BindingMovementInput>(binding, input));
        }
        if (virtual) {
            this.activeVirtualBinding = binding;
        }
        return true;
    }

    private void handleActiveVirtualBinding() {
        ButtonBinding virtualBinding = this.activeVirtualBinding;
        if (virtualBinding == null) {
            return;
        }
        if (virtualBinding.isButtonDown() && ButtonBindings.RADIAL_MENU.isButtonDown()) {
            return;
        }
        this.activeVirtualBinding = null;
        ButtonBinding.setButtonState(virtualBinding, false);
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (!virtualBinding.getContext().isActive()) {
            return;
        }
        ButtonHandler buttonHandler = virtualBinding.getHandler();
        if (!(buttonHandler instanceof BindingReleased)) {
            return;
        }
        BindingReleased released = (BindingReleased)((Object)buttonHandler);
        Minecraft mc = Minecraft.getInstance();
        Context context = new Context(virtualBinding, controller, mc, mc.player, (Level)mc.level, mc.screen, false);
        released.handleReleased(context);
    }

    private void onStartClickTick() {
        this.handleActiveVirtualBinding();
        this.runTickHandler(BindingOnTick.TickPhase.START_CLIENT);
    }

    private void onEndClickTick() {
        this.runTickHandler(BindingOnTick.TickPhase.END_CLIENT);
    }

    private void onStartPlayerTick(Player player) {
        this.runTickHandler(BindingOnTick.TickPhase.START_PLAYER);
    }

    private void onEndPlayerTick(Player player) {
        this.runTickHandler(BindingOnTick.TickPhase.END_PLAYER);
    }

    private void runTickHandler(BindingOnTick.TickPhase type) {
        Minecraft mc = Minecraft.getInstance();
        Controller controller = Controllable.getController();
        this.activeTickHandlers.get((Object)type).removeIf(handler -> {
            if (controller == null) {
                return true;
            }
            ButtonBinding binding = handler.binding();
            if (!binding.isButtonDown() || !binding.getContext().isActive()) {
                return true;
            }
            Context context = new Context(handler.binding, controller, mc, mc.player, (Level)mc.level, mc.screen, false);
            ((BindingOnTick)handler.handler()).handleTick(context);
            return false;
        });
    }

    private void updateInput(Player player, Input input) {
        LocalPlayer localPlayer = (LocalPlayer)player;
        if (localPlayer == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Controller controller = Controllable.getController();
        this.activeMovementInputHandlers.removeIf(handler -> {
            if (controller == null) {
                return true;
            }
            ButtonBinding binding = handler.binding();
            if (!binding.isButtonDown() || !binding.getContext().isActive()) {
                return true;
            }
            MovementInputContext context = new MovementInputContext(handler.binding, controller, mc, mc.player, (Level)mc.level, mc.screen, false, input);
            ((BindingMovementInput)handler.handler()).handleMovementInput(context);
            return false;
        });
        if (!(mc.screen != null || controller == null || Controllable.getRadialMenu().isVisible() && Config.CLIENT.options.radialThumbstick.get() == Thumbstick.LEFT || EventHelper.postMoveEvent())) {
            float threshold;
            float sneakSpeed = (float)localPlayer.getAttributeValue(Attributes.SNEAKING_SPEED);
            float sneakBonus = localPlayer.isMovingSlowly() ? sneakSpeed : 1.0f;
            float inputX = InputHelper.getCombinedPressedValue(controller, ButtonBindings.STRAFE_LEFT, ButtonBindings.STRAFE_RIGHT);
            float inputY = InputHelper.getCombinedPressedValue(controller, ButtonBindings.WALK_FORWARDS, ButtonBindings.WALK_BACKWARDS);
            AnalogMovement movement = (AnalogMovement)Config.CLIENT.options.analogMovement.get();
            if (movement != AnalogMovement.ALWAYS) {
                ServerData data = mc.getCurrentServer();
                if (movement != AnalogMovement.LOCAL_ONLY || data != null && data.type() == ServerData.Type.OTHER) {
                    inputX = Math.abs(inputX) >= 0.5f ? Math.signum(inputX) : 0.0f;
                    float f = inputY = Math.abs(inputY) >= 0.5f ? Math.signum(inputY) : 0.0f;
                }
            }
            if (Math.abs(inputY) > 0.0f) {
                input.up = inputY < 0.0f;
                input.down = inputY > 0.0f;
                input.forwardImpulse = -inputY;
                input.forwardImpulse *= sneakBonus;
                controller.updateInputTime();
            }
            float f = threshold = localPlayer.getVehicle() instanceof Boat ? 0.5f : 0.0f;
            if (Math.abs(inputX) > threshold) {
                input.right = inputX > 0.0f;
                input.left = inputX < 0.0f;
                input.leftImpulse = -inputX;
                input.leftImpulse *= sneakBonus;
                controller.updateInputTime();
            }
        }
    }

    public static void navigateToHotbarSlot(Context context, int index) {
        if (context.screen().isEmpty()) {
            context.player().ifPresent(player -> {
                player.getInventory().selected = index;
            });
        }
    }

    public static void toggleCraftBook(Context context) {
        context.screen().ifPresent(screen -> {
            if (screen instanceof RecipeUpdateListener) {
                RecipeUpdateListener listener = (RecipeUpdateListener)screen;
                ClientServices.CLIENT.getScreenRenderables((Screen)screen).stream().filter(widget -> {
                    ImageButton btn;
                    return widget instanceof ImageButton && RecipeBookComponent.RECIPE_BUTTON_SPRITES.equals((Object)ClientServices.CLIENT.getImageButtonResource(btn = (ImageButton)widget));
                }).findFirst().ifPresent(btn -> ((Button)btn).onPress());
                boolean visible = listener.getRecipeBookComponent().isVisible();
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)(visible ? 1.0f : 0.95f)));
            }
        });
    }

    private void cycleThirdPersonView() {
        Minecraft mc = Minecraft.getInstance();
        CameraType cameraType = mc.options.getCameraType();
        mc.options.setCameraType(cameraType.cycle());
        if (cameraType.isFirstPerson() != mc.options.getCameraType().isFirstPerson()) {
            mc.gameRenderer.checkEntityPostEffect(mc.options.getCameraType().isFirstPerson() ? mc.getCameraEntity() : null);
        }
    }

    public static void navigateCreativeTabs(CreativeModeInventoryScreen screen, int dir) {
        ClientServices.CLIENT.scrollCreativeTabs(screen, dir);
    }

    public static void navigateRecipeTab(RecipeBookComponent recipeBook, int dir) {
        if (!recipeBook.isVisible()) {
            return;
        }
        RecipeBookComponentAccessor recipeBookMixin = (RecipeBookComponentAccessor)recipeBook;
        RecipeBookTabButton currentTab = recipeBookMixin.controllableGetCurrentTab();
        List<RecipeBookTabButton> tabs = recipeBookMixin.controllableGetRecipeTabs();
        int currentTabIndex = tabs.indexOf(currentTab);
        RecipeBookTabButton newTab = null;
        if (dir > 0) {
            for (int i = currentTabIndex + 1; i < tabs.size(); ++i) {
                if (!tabs.get((int)i).visible) continue;
                newTab = tabs.get(i);
                break;
            }
        } else {
            for (int i = currentTabIndex - 1; i >= 0; --i) {
                if (!tabs.get((int)i).visible) continue;
                newTab = tabs.get(i);
                break;
            }
        }
        if (newTab != null) {
            currentTab.setStateTriggered(false);
            recipeBookMixin.controllableSetCurrentTab(newTab);
            newTab.setStateTriggered(true);
            recipeBookMixin.controllableUpdateCollections(true);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
    }

    public static void navigateRecipePage(RecipeBookComponent recipeBook, int dir) {
        if (!recipeBook.isVisible()) {
            return;
        }
        RecipeBookPageAccessor page = (RecipeBookPageAccessor)((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
        if (dir > 0 && page.controllableGetForwardButton().visible || dir < 0 && page.controllableGetBackButton().visible) {
            int currentPage = page.controllableGetCurrentPage();
            page.controllableSetCurrentPage(currentPage + dir);
            page.controllableUpdateButtonsForPage();
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
    }

    public static void navigateTabBar(Screen screen, int direction) {
        TabNavigationBar bar = screen.children().stream().filter(listener -> listener instanceof TabNavigationBar).map(listener -> (TabNavigationBar)listener).findFirst().orElse(null);
        if (bar != null) {
            int newIndex;
            ArrayList buttons = new ArrayList();
            bar.children().forEach(listener -> {
                if (listener instanceof TabButton) {
                    TabButton button = (TabButton)listener;
                    buttons.add(button);
                }
            });
            int selectedIndex = buttons.stream().filter(TabButton::isSelected).map(buttons::indexOf).findFirst().orElse(-1);
            if (selectedIndex != -1 && (newIndex = selectedIndex + direction) >= 0 && newIndex < buttons.size()) {
                bar.selectTab(newIndex, true);
            }
        }
    }

    public static void navigateCursor(Screen screen, Navigate navigate) {
        if (!Controllable.getCursor().isEnabled()) {
            return;
        }
        int cursorScreenX = Controllable.getCursor().getScreenX();
        int cursorScreenY = Controllable.getCursor().getScreenY();
        List<NavigationPoint> points = InputHandler.gatherNavigationPoints(screen, navigate, cursorScreenX, cursorScreenY);
        points.removeIf(p -> !navigate.canMoveTo().test((NavigationPoint)p, cursorScreenX, cursorScreenY));
        if (points.isEmpty()) {
            return;
        }
        Vector2d cursorVec = new Vector2d((double)cursorScreenX, (double)cursorScreenY);
        Optional<NavigationPoint> minimumPointOptional = points.stream().min(navigate.oppositeAxisOffsetComparator(cursorScreenX, cursorScreenY));
        double additionalDelta = 50.0;
        double minimumDelta = navigate.oppositeAxisOffset().apply(minimumPointOptional.get(), cursorVec) + additionalDelta;
        Optional<NavigationPoint> targetPointOptional = points.stream().filter(point -> navigate.oppositeAxisOffset().apply((NavigationPoint)point, cursorVec) <= minimumDelta).min(Comparator.comparing(p -> p.distanceTo(cursorScreenX, cursorScreenY)));
        if (targetPointOptional.isPresent()) {
            NavigationPoint targetPoint = targetPointOptional.get();
            targetPoint.onNavigate();
            Minecraft mc = Minecraft.getInstance();
            mc.tell(() -> {
                VirtualCursor cursor = Controllable.getCursor();
                int targetCursorX = cursor.getX();
                int targetCursorY = cursor.getY();
                MouseHooks.invokeMouseMoved(screen, targetCursorX, targetCursorY, 0.0, 0.0);
                int windowPointX = (int)(targetPoint.getX() * mc.getWindow().getGuiScale());
                int windowPointY = (int)(targetPoint.getY() * mc.getWindow().getGuiScale());
                cursor.jumpCursorTo(windowPointX, windowPointY);
                if (((Boolean)Config.CLIENT.options.navigateSound.get()).booleanValue()) {
                    mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)2.0f));
                }
                MouseHooks.invokeMouseMoved(screen, windowPointX, windowPointY, windowPointX - targetCursorX, windowPointY - targetCursorY);
                cursor.setVisible(!targetPoint.shouldHide());
            });
        }
    }

    private static List<NavigationPoint> gatherNavigationPoints(Screen screen, Navigate navigate, int cursorX, int cursorY) {
        int buttonHeight;
        int startX;
        RecipeBookComponent recipeBook;
        ArrayList<NavigationPoint> points = new ArrayList<NavigationPoint>();
        ArrayList<Object> widgets = new ArrayList<Object>();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            int n = ClientServices.CLIENT.getScreenLeft(containerScreen);
            int guiTop = ClientServices.CLIENT.getScreenTop(containerScreen);
            for (Slot slot : containerScreen.getMenu().slots) {
                if (ClientServices.CLIENT.getSlotUnderMouse(containerScreen) == slot) continue;
                int posX = n + slot.x + 8;
                int posY = guiTop + slot.y + 8;
                points.add(new SlotNavigationPoint((double)posX, (double)posY, slot));
            }
        }
        for (GuiEventListener guiEventListener : screen.children()) {
            InputHandler.gatherNavigationPointsFromListener(guiEventListener, navigate, cursorX, cursorY, points, null, null);
        }
        if (screen instanceof RecipeUpdateListener && (recipeBook = ((RecipeUpdateListener)screen).getRecipeBookComponent()).isVisible()) {
            widgets.add(((RecipeBookComponentAccessor)recipeBook).controllableGetFilterButton());
            widgets.addAll(((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeTabs());
            RecipeBookPage recipeBookPage = ((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
            OverlayRecipeComponent overlay = ((RecipeBookPageAccessor)recipeBookPage).controllableGetOverlay();
            if (overlay.isVisible()) {
                widgets.addAll(((OverlayRecipeComponentAccessor)overlay).controllableGetRecipeButtons());
            } else {
                RecipeBookPage recipeBookPage2 = ((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
                widgets.addAll(((RecipeBookPageAccessor)recipeBookPage2).controllableGetButtons());
                widgets.add(((RecipeBookPageAccessor)recipeBookPage2).controllableGetForwardButton());
                widgets.add(((RecipeBookPageAccessor)recipeBookPage2).controllableGetBackButton());
            }
        }
        if (screen instanceof EnchantmentScreen) {
            EnchantmentScreen enchantmentScreen = (EnchantmentScreen)screen;
            int n = ClientServices.CLIENT.getScreenLeft((AbstractContainerScreen<?>)enchantmentScreen) + 60;
            int startY = ClientServices.CLIENT.getScreenTop((AbstractContainerScreen<?>)enchantmentScreen) + 14;
            int itemWidth = 108;
            int itemHeight = 19;
            for (int i = 0; i < 3; ++i) {
                double itemX = (double)n + (double)itemWidth / 2.0;
                double itemY = (double)(startY + itemHeight * i) + (double)itemHeight / 2.0;
                points.add(new BasicNavigationPoint(itemX, itemY));
            }
        }
        if (screen instanceof StonecutterScreen) {
            int offsetIndex;
            StonecutterScreen stonecutter = (StonecutterScreen)screen;
            StonecutterMenu stonecutterMenu = (StonecutterMenu)stonecutter.getMenu();
            startX = ClientServices.CLIENT.getScreenLeft((AbstractContainerScreen<?>)stonecutter) + 52;
            int startY = ClientServices.CLIENT.getScreenTop((AbstractContainerScreen<?>)stonecutter) + 14;
            int buttonWidth = 16;
            buttonHeight = 18;
            for (int index = offsetIndex = ClientServices.CLIENT.getStonecutterStartIndex(stonecutter); index < offsetIndex + 12 && index < stonecutterMenu.getNumRecipes(); ++index) {
                int buttonIndex = index - offsetIndex;
                int buttonX = startX + buttonIndex % 4 * buttonWidth;
                int buttonY = startY + buttonIndex / 4 * buttonHeight + 2;
                points.add(new BasicNavigationPoint((double)buttonX + (double)buttonWidth / 2.0, (double)buttonY + (double)buttonHeight / 2.0));
            }
        }
        if (screen instanceof LoomScreen) {
            LoomScreen loom = (LoomScreen)screen;
            List list = ((LoomMenu)loom.getMenu()).getSelectablePatterns();
            startX = ClientServices.CLIENT.getScreenLeft((AbstractContainerScreen<?>)loom) + 60;
            int startY = ClientServices.CLIENT.getScreenTop((AbstractContainerScreen<?>)loom) + 13;
            int buttonWidth = 14;
            buttonHeight = 14;
            int offsetRow = ClientServices.CLIENT.getLoomStartRow(loom);
            for (int i = 0; i < 4; ++i) {
                int buttonIndex;
                for (int j = 0; j < 4 && (buttonIndex = (i + offsetRow) * 4 + j) < list.size(); ++j) {
                    int buttonX = startX + j * buttonWidth;
                    int buttonY = startY + i * buttonHeight;
                    points.add(new BasicNavigationPoint((double)buttonX + (double)buttonWidth / 2.0, (double)buttonY + (double)buttonHeight / 2.0));
                }
            }
        }
        for (AbstractWidget abstractWidget : widgets) {
            if (abstractWidget == null || abstractWidget.isHovered() || !abstractWidget.visible || !abstractWidget.active) continue;
            points.add(new WidgetNavigationPoint(abstractWidget));
        }
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
            ClientServices.CLIENT.gatherCreativeTabNavigationPoints(creativeScreen, points);
        }
        if (Controllable.isJeiLoaded() && ClientHelper.isPlayingGame()) {
            points.addAll(JeiSupport.getNavigationPoints());
        }
        if (Controllable.isEmiLoaded() && ClientHelper.isPlayingGame()) {
            points.addAll(EmiSupport.getNavigationPoints(screen));
        }
        if (Controllable.isReiLoaded() && ClientHelper.isPlayingGame()) {
            points.addAll(ReiSupport.getNavigationPoints(screen));
        }
        ((ControllerEvents.GatherNavigationPoints)ControllerEvents.GATHER_NAVIGATION_POINTS.post()).handle(points);
        return points;
    }

    private static void gatherNavigationPointsFromListener(GuiEventListener listener, Navigate navigate, int cursorX, int cursorY, List<NavigationPoint> points, @Nullable AbstractSelectionList<?> list, @Nullable GuiEventListener entry) {
        if (listener instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)listener;
            navigatable.elements().forEach(child -> InputHandler.gatherNavigationPointsFromListener(child, navigate, cursorX, cursorY, points, list, entry));
        } else if (listener instanceof AbstractSelectionList) {
            AbstractSelectionList selectionList = (AbstractSelectionList)listener;
            InputHandler.gatherNavigationPointsFromAbstractList(selectionList, navigate, cursorX, cursorY, points);
        } else if (listener instanceof TabNavigationBar) {
            TabNavigationBar navigationBar = (TabNavigationBar)listener;
            navigationBar.children().forEach(child -> {
                if (child instanceof TabButton) {
                    TabButton button = (TabButton)child;
                    InputHandler.createWidgetNavigationPoint((AbstractWidget)button, points, list, entry);
                }
            });
        } else if (listener instanceof ContainerEventHandler) {
            ContainerEventHandler handler = (ContainerEventHandler)listener;
            handler.children().forEach(child -> InputHandler.gatherNavigationPointsFromListener(child, navigate, cursorX, cursorY, points, list, entry));
        } else if (listener instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)listener;
            if (widget.active && widget.visible) {
                InputHandler.createWidgetNavigationPoint(widget, points, list, entry);
            }
        }
    }

    private static void createWidgetNavigationPoint(AbstractWidget widget, List<NavigationPoint> points, @Nullable AbstractSelectionList<?> list, @Nullable GuiEventListener entry) {
        if (widget == null || widget.isHovered() || !widget.visible || !widget.active) {
            return;
        }
        if (list != null && entry != null) {
            points.add(new ListWidgetNavigationPoint(widget, list, entry));
        } else {
            points.add(new WidgetNavigationPoint(widget));
        }
    }

    private static void gatherNavigationPointsFromAbstractList(AbstractSelectionList<?> list, Navigate navigate, int cursorX, int cursorY, List<NavigationPoint> points) {
        List children = list.children();
        int dir = navigate == Navigate.UP ? -1 : 1;
        int itemHeight = ClientServices.CLIENT.getListItemHeight(list);
        for (int i = 0; i < children.size(); ++i) {
            GuiEventListener entry = (GuiEventListener)children.get(i);
            int rowTop = ClientServices.CLIENT.getAbstractListRowTop(list, i);
            int rowBottom = ClientServices.CLIENT.getAbstractListRowBottom(list, i);
            int listTop = ClientServices.CLIENT.getAbstractListTop(list);
            int listBottom = ClientServices.CLIENT.getAbstractListBottom(list);
            if (rowTop > listTop - itemHeight && rowBottom < listBottom + itemHeight) {
                if (!(navigate != Navigate.UP && navigate != Navigate.DOWN || entry instanceof SkipItem && (i == 0 || i == children.size() - 1))) {
                    points.add(new ListEntryNavigationPoint(list, entry, i, dir));
                }
                InputHandler.gatherNavigationPointsFromListener(entry, navigate, cursorX, cursorY, points, list, entry);
                continue;
            }
            if (!list.isMouseOver((double)cursorX, (double)cursorY)) continue;
            points.add(new ListEntryNavigationPoint(list, entry, i, dir));
        }
    }

    public static void craftRecipeBookItem() {
        AbstractContainerScreen screen;
        Screen screen2;
        block10: {
            block9: {
                Minecraft mc = Minecraft.getInstance();
                if (mc.player == null) {
                    return;
                }
                screen2 = mc.screen;
                if (!(screen2 instanceof AbstractContainerScreen)) break block9;
                screen = (AbstractContainerScreen)screen2;
                screen2 = mc.screen;
                if (screen2 instanceof RecipeUpdateListener) break block10;
            }
            return;
        }
        RecipeUpdateListener listener = (RecipeUpdateListener)screen2;
        if (!listener.getRecipeBookComponent().isVisible()) {
            return;
        }
        if (!(screen.getMenu() instanceof RecipeBookMenu)) {
            return;
        }
        RecipeBookPage recipeBookPage = ((RecipeBookComponentAccessor)listener.getRecipeBookComponent()).controllableGetRecipeBookPage();
        RecipeButton recipeButton = ((RecipeBookPageAccessor)recipeBookPage).controllableGetButtons().stream().filter(AbstractWidget::isHoveredOrFocused).findFirst().orElse(null);
        if (recipeButton != null) {
            RecipeBookMenu menu = (RecipeBookMenu)screen.getMenu();
            Slot slot = menu.getSlot(menu.getResultSlotIndex());
            int screenLeft = ClientServices.CLIENT.getScreenLeft(screen);
            int screenTop = ClientServices.CLIENT.getScreenTop(screen);
            if (menu.getCarried().isEmpty()) {
                MouseHooks.invokeMouseClick((Screen)screen, 0, screenLeft + slot.x + 8, screenTop + slot.y + 8);
            } else {
                MouseHooks.invokeMouseReleased((Screen)screen, 0, screenLeft + slot.x + 8, screenTop + slot.y + 8);
            }
        }
    }

    public void clearActiveHandlers() {
        this.activeTickHandlers.clear();
        this.activeRenderHandlers.clear();
        this.activeMovementInputHandlers.clear();
    }

    private static class PriorityHandler<T>
    implements Comparable<PriorityHandler<T>> {
        private final ButtonBinding binding;
        private final T handler;
        private final int priority;

        public PriorityHandler(ButtonBinding binding, T handler) {
            this.binding = binding;
            this.handler = handler;
            this.priority = binding.getContext().priority();
        }

        public ButtonBinding binding() {
            return this.binding;
        }

        public T handler() {
            return this.handler;
        }

        @Override
        public int compareTo(PriorityHandler<T> o) {
            int result = -Integer.compare(this.priority, o.priority);
            if (result == 0) {
                return this.binding.getDescription().compareTo(o.binding.getDescription());
            }
            return result;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof PriorityHandler)) {
                return false;
            }
            PriorityHandler that = (PriorityHandler)o;
            return this.binding.equals(that.binding);
        }

        public int hashCode() {
            return this.binding.hashCode();
        }

        public String toString() {
            return this.priority + " " + this.binding.getDescription();
        }
    }

    public static enum Navigate {
        UP((p, x, y) -> p.getY() < (double)y, (p, v) -> Math.abs(p.getX() - v.x)),
        DOWN((p, x, y) -> p.getY() > (double)(y + 1), (p, v) -> Math.abs(p.getX() - v.x)),
        LEFT((p, x, y) -> p.getX() < (double)x, (p, v) -> Math.abs(p.getY() - v.y)),
        RIGHT((p, x, y) -> p.getX() > (double)(x + 1), (p, v) -> Math.abs(p.getY() - v.y));

        private final NavigatePredicate predicate;
        private final BiFunction<? super NavigationPoint, Vector2d, Double> keyExtractor;

        private Navigate(NavigatePredicate predicate, BiFunction<? super NavigationPoint, Vector2d, Double> keyExtractor) {
            this.predicate = predicate;
            this.keyExtractor = keyExtractor;
        }

        public NavigatePredicate canMoveTo() {
            return this.predicate;
        }

        public BiFunction<? super NavigationPoint, Vector2d, Double> oppositeAxisOffset() {
            return this.keyExtractor;
        }

        public Comparator<NavigationPoint> oppositeAxisOffsetComparator(int cursorX, int cursorY) {
            return Comparator.comparing(p -> this.keyExtractor.apply((NavigationPoint)p, new Vector2d((double)cursorX, (double)cursorY)));
        }
    }

    private static interface NavigatePredicate {
        public boolean test(NavigationPoint var1, int var2, int var3);
    }
}

