/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.gui.RadialMenuAction;
import com.mrcrayfish.controllable.client.gui.screens.RadialMenuConfigureScreen;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.settings.Thumbstick;
import com.mrcrayfish.controllable.platform.ClientServices;
import com.mrcrayfish.controllable.util.Utils;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.ITickEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fStack;

public class RadialMenu {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/controller.png");
    private static final int ANIMATE_DURATION = 5;
    private static RadialMenu instance;
    private boolean initialized;
    private boolean loaded;
    private boolean visible;
    private int animateTicks;
    private int prevAnimateTicks;
    private Set<RadialMenuAction> actions = new LinkedHashSet<RadialMenuAction>();
    private AbstractRadialItem settingsItem;
    private AbstractRadialItem closeItem;
    private List<AbstractRadialItem> allItems = new ArrayList<AbstractRadialItem>();
    private List<AbstractRadialItem> leftItems = new ArrayList<AbstractRadialItem>();
    private List<AbstractRadialItem> rightItems = new ArrayList<AbstractRadialItem>();
    private AbstractRadialItem selected;

    @ApiStatus.Internal
    public RadialMenu() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Only one instance of RadialMenu is allowed");
        instance = this;
    }

    @ApiStatus.Internal
    public void registerEvents() {
        if (!this.initialized) {
            TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)this::onClientTickStart));
            TickEvents.END_CLIENT.register((IFrameworkEvent)((ITickEvent.EndClient)this::onClientTickEnd));
            TickEvents.END_RENDER.register((IFrameworkEvent)((ITickEvent.EndRender)this::onRenderEnd));
            this.initialized = true;
        }
    }

    public void load() {
        if (this.loaded) {
            return;
        }
        Path path = Utils.getConfigDirectory().resolve("controllable").resolve("radial_menu_items.json");
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path.toFile()), Charsets.UTF_8));){
                JsonArray bindings = (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class);
                bindings.forEach(element -> {
                    JsonObject object = element.getAsJsonObject();
                    String key = GsonHelper.getAsString((JsonObject)object, (String)"key");
                    String colorName = GsonHelper.getAsString((JsonObject)object, (String)"color");
                    ButtonBinding binding = Controllable.getBindingRegistry().getBindingByDescriptionKey(key);
                    if (binding != null) {
                        ChatFormatting color = ChatFormatting.getByName((String)colorName);
                        if (color == null || color.getColor() == null) {
                            color = ChatFormatting.YELLOW;
                        }
                        this.actions.add(new RadialMenuAction(binding, color));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.actions.addAll(this.createDefaultActions());
            this.save();
        }
        this.loaded = true;
    }

    private void save() {
        JsonArray array = new JsonArray();
        this.actions.forEach(data -> {
            JsonObject object = new JsonObject();
            object.addProperty("key", data.getBinding().getDescription());
            object.addProperty("color", data.getColor().name());
            array.add((JsonElement)object);
        });
        try {
            String json = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)array);
            Path path = Utils.getConfigDirectory().resolve("controllable").resolve("radial_menu_items.json");
            Files.writeString(path, (CharSequence)json, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<RadialMenuAction> createDefaultActions() {
        ArrayList<RadialMenuAction> defaults = new ArrayList<RadialMenuAction>();
        defaults.add(new RadialMenuAction(ButtonBindings.OPEN_CONTROLLABLE_SETTINGS, ChatFormatting.BLUE));
        defaults.add(new RadialMenuAction(ButtonBindings.ADVANCEMENTS, ChatFormatting.YELLOW));
        defaults.add(new RadialMenuAction(ButtonBindings.SCREENSHOT, ChatFormatting.YELLOW));
        defaults.add(new RadialMenuAction(ButtonBindings.FULLSCREEN, ChatFormatting.YELLOW));
        return defaults;
    }

    @ApiStatus.Internal
    public void interact() {
        if (this.visible) {
            if (this.selected != null) {
                this.selected.onUseItem(this);
            }
        } else {
            this.load();
            this.setVisibility(true);
            this.populateAndConstruct();
            Minecraft mc = Minecraft.getInstance();
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_LOOM_TAKE_RESULT, (float)1.5f));
        }
    }

    public AbstractRadialItem getSelected() {
        return this.selected;
    }

    public LinkedHashSet<RadialMenuAction> getActions() {
        return new LinkedHashSet<RadialMenuAction>(this.actions);
    }

    public void setActions(Collection<RadialMenuAction> actions) {
        this.actions = new LinkedHashSet<RadialMenuAction>(actions);
        this.save();
        this.populateAndConstruct();
    }

    public void removeBinding(ButtonBinding binding) {
        if (this.actions.removeIf(data -> data.getBinding() == binding)) {
            this.save();
            this.populateAndConstruct();
        }
    }

    private void setVisibility(boolean visible) {
        this.visible = visible;
    }

    private void clearAnimation() {
        this.animateTicks = 0;
        this.prevAnimateTicks = 0;
    }

    private void populateAndConstruct() {
        this.rightItems.clear();
        this.leftItems.clear();
        ArrayList<AbstractRadialItem> items = new ArrayList<AbstractRadialItem>();
        this.actions.forEach(binding -> items.add(new ButtonBindingItem((RadialMenuAction)binding)));
        int rightSize = items.size() / 2;
        for (int i = 0; i < rightSize; ++i) {
            float gap = 180.0f / (float)(rightSize + 1);
            AbstractRadialItem item = (AbstractRadialItem)items.get(i);
            item.setAngle(gap * (float)i + gap);
            this.rightItems.add(item);
        }
        int leftSize = items.size() - rightSize;
        for (int i = rightSize; i < items.size(); ++i) {
            float gap = 180.0f / (float)(leftSize + 1);
            AbstractRadialItem item = (AbstractRadialItem)items.get(i);
            item.setAngle(360.0f - gap * (float)(i - rightSize) - gap);
            this.leftItems.add((AbstractRadialItem)items.get(i));
        }
        this.settingsItem = new RadialSettingsItem();
        this.settingsItem.setAngle(0.0f);
        items.add(this.settingsItem);
        this.closeItem = new CloseRadialMenuItem();
        this.closeItem.setAngle(180.0f);
        items.add(this.closeItem);
        this.selected = this.closeItem;
        this.allItems = items;
    }

    public boolean isVisible() {
        return this.visible;
    }

    private void onClientTickStart() {
        Controller controller = Controllable.getController();
        if (this.visible && (controller == null || !controller.isBeingUsed())) {
            this.setVisibility(false);
        }
    }

    private void onRenderEnd(DeltaTracker tracker) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.screen != null) {
            return;
        }
        if (Controllable.getController() != null && (this.visible || this.animateTicks > 0 || this.prevAnimateTicks > 0)) {
            this.renderRadialMenu(tracker);
        }
    }

    private void onClientTickEnd() {
        this.prevAnimateTicks = this.animateTicks;
        if (this.visible) {
            if (this.animateTicks < 5) {
                ++this.animateTicks;
            }
        } else if (this.animateTicks > 0) {
            --this.animateTicks;
        }
    }

    private void renderRadialMenu(DeltaTracker tracker) {
        this.updateSelected();
        Matrix4fStack modelStack = RenderSystem.getModelViewStack();
        modelStack.pushMatrix();
        modelStack.identity();
        modelStack.translate(0.0f, 0.0f, 1000.0f - ClientServices.CLIENT.getGuiFarPlane());
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
        Minecraft mc = Minecraft.getInstance();
        GuiGraphics graphics = new GuiGraphics(mc, mc.renderBuffers().bufferSource());
        PoseStack poseStack = graphics.pose();
        float animation = Mth.lerp((float)tracker.getGameTimeDeltaPartialTick(false), (float)this.prevAnimateTicks, (float)this.animateTicks) / 5.0f;
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        animation = (float)(1.0 + (double)c3 * Math.pow(animation - 1.0f, 3.0) + (double)c1 * Math.pow(animation - 1.0f, 2.0));
        graphics.fill(0, 0, mc.getWindow().getWidth(), mc.getWindow().getHeight(), 2014318608);
        poseStack.translate(0.0f, -10.0f, 0.0f);
        poseStack.translate((float)((int)((float)mc.getWindow().getGuiScaledWidth() / 2.0f)), (float)((int)((float)mc.getWindow().getGuiScaledHeight() / 2.0f)), 0.0f);
        poseStack.pushPose();
        this.settingsItem.draw(graphics, mc, false, this.selected == this.settingsItem, animation);
        poseStack.popPose();
        poseStack.pushPose();
        this.closeItem.draw(graphics, mc, false, this.selected == this.closeItem, animation);
        poseStack.popPose();
        this.drawRadialItems(this.rightItems, graphics, mc, animation);
        this.drawRadialItems(this.leftItems, graphics, mc, animation);
        modelStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private void drawRadialItems(List<AbstractRadialItem> items, GuiGraphics graphics, Minecraft mc, float animation) {
        for (int i = 0; i < items.size(); ++i) {
            AbstractRadialItem item = items.get(i);
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            if (i == 0) {
                poseStack.translate(0.0f, -10.0f, 0.0f);
            }
            if (i == items.size() - 1) {
                poseStack.translate(0.0f, 10.0f, 0.0f);
            }
            boolean left = item.angle >= 180.0f;
            float x = (float)Math.cos(Math.toRadians(item.angle - 90.0f)) * 70.0f;
            float y = (float)Math.sin(Math.toRadians(item.angle - 90.0f)) * 70.0f;
            poseStack.translate((float)((int)x), (float)((int)y), 0.0f);
            item.draw(graphics, mc, left, this.selected == item, animation);
            poseStack.popPose();
        }
    }

    private void updateSelected() {
        float inputY;
        if (!this.visible) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        float threshold = 0.5f;
        float inputX = Config.CLIENT.options.radialThumbstick.get() == Thumbstick.RIGHT ? controller.getRThumbStickXValue() : controller.getLThumbStickXValue();
        float f = inputY = Config.CLIENT.options.radialThumbstick.get() == Thumbstick.RIGHT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(inputX) <= threshold && Math.abs(inputY) <= threshold) {
            return;
        }
        float selectedAngle = (float)(Mth.wrapDegrees((double)(Math.toDegrees(Math.atan2(inputY, inputX)) - 90.0)) + 180.0);
        Optional closest = this.allItems.stream().min((o1, o2) -> Mth.degreesDifferenceAbs((float)o1.angle, (float)selectedAngle) > Mth.degreesDifferenceAbs((float)o2.angle, (float)selectedAngle) ? 1 : 0);
        if (closest.isEmpty()) {
            return;
        }
        if (closest.get() == this.selected) {
            return;
        }
        this.selected = (AbstractRadialItem)closest.get();
        Minecraft mc = Minecraft.getInstance();
        if (((Boolean)Config.CLIENT.options.navigateSound.get()).booleanValue()) {
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)1.5f));
        }
    }

    private Optional<AbstractRadialItem> getSelectedItem() {
        return Optional.empty();
    }

    public static abstract class AbstractRadialItem {
        protected Component label;
        protected Component description;
        private float angle;

        protected AbstractRadialItem(Component label) {
            this(label, null);
        }

        protected AbstractRadialItem(Component label, Component description) {
            this.label = label;
            this.description = description;
        }

        public Component getLabel() {
            return this.label;
        }

        @Nullable
        public Component getDescription() {
            return this.description;
        }

        public boolean isEmpty() {
            return false;
        }

        public abstract void onUseItem(RadialMenu var1);

        protected abstract void draw(GuiGraphics var1, Minecraft var2, boolean var3, boolean var4, float var5);

        protected void playSound(SoundEvent event, float pitch) {
            Minecraft mc = Minecraft.getInstance();
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)event, (float)pitch));
        }

        void setAngle(float angle) {
            this.angle = angle;
        }
    }

    public static final class RadialSettingsItem
    extends AbstractRadialItem {
        private static final Component LABEL = Component.translatable((String)"controllable.gui.configure");

        public RadialSettingsItem() {
            super((Component)Component.translatable((String)"controllable.gui.radial.settings"));
        }

        @Override
        public void onUseItem(RadialMenu handler) {
            handler.setVisibility(false);
            handler.clearAnimation();
            Minecraft.getInstance().setScreen((Screen)new RadialMenuConfigureScreen(null));
        }

        @Override
        protected void draw(GuiGraphics graphics, Minecraft mc, boolean left, boolean selected, float animation) {
            int color = selected ? -3355444 : mc.options.getBackgroundColor(0.7f);
            float alpha = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
            float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
            float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
            float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
            PoseStack poseStack = graphics.pose();
            poseStack.translate(0.0f, -90.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            alpha = Math.min(1.0f, alpha * animation);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex(poseStack.last().pose(), -14.0f, -15.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), -14.0f, -14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 14.0f, -14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 14.0f, -15.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), -15.0f, -14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), -15.0f, 14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 15.0f, 14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 15.0f, -14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), -14.0f, 14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), -14.0f, 15.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 14.0f, 15.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 14.0f, 14.0f, 0.0f).setColor(red, green, blue, alpha);
            MeshData data = buffer.build();
            if (data != null) {
                BufferUploader.drawWithShader((MeshData)data);
            }
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(TEXTURE, -10, -10, 20, 20, 88.0f, 15.0f, 10, 10, 256, 256);
            if (selected) {
                graphics.drawCenteredString(mc.font, LABEL, 0, 21, 0xFFFFFF);
            }
        }
    }

    public static final class CloseRadialMenuItem
    extends AbstractRadialItem {
        private static final Component LABEL = Component.translatable((String)"controllable.gui.close");

        public CloseRadialMenuItem() {
            super((Component)Component.translatable((String)"controllable.gui.radial.close"));
        }

        @Override
        public void onUseItem(RadialMenu handler) {
            handler.setVisibility(false);
            Minecraft mc = Minecraft.getInstance();
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_LOOM_TAKE_RESULT, (float)1.3f));
        }

        @Override
        protected void draw(GuiGraphics graphics, Minecraft mc, boolean left, boolean selected, float animation) {
            int color = selected ? -3355444 : mc.options.getBackgroundColor(0.7f);
            float alpha = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
            float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
            float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
            float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
            PoseStack poseStack = graphics.pose();
            poseStack.translate(0.0f, 90.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            alpha = Math.min(1.0f, alpha * animation);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex(poseStack.last().pose(), -14.0f, -15.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), -14.0f, -14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 14.0f, -14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 14.0f, -15.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), -15.0f, -14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), -15.0f, 14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 15.0f, 14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 15.0f, -14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), -14.0f, 14.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), -14.0f, 15.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 14.0f, 15.0f, 0.0f).setColor(red, green, blue, alpha);
            buffer.addVertex(poseStack.last().pose(), 14.0f, 14.0f, 0.0f).setColor(red, green, blue, alpha);
            MeshData data = buffer.build();
            if (data != null) {
                BufferUploader.drawWithShader((MeshData)data);
            }
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(TEXTURE, -10, -10, 20, 20, 98.0f, 15.0f, 10, 10, 256, 256);
            if (selected) {
                graphics.drawCenteredString(mc.font, LABEL, 0, -30, 0xFFFFFF);
            }
        }
    }

    private static class ButtonBindingItem
    extends AbstractRadialItem {
        public RadialMenuAction entry;

        public ButtonBindingItem(RadialMenuAction entry) {
            super((Component)Component.translatable((String)entry.getBinding().getLabelKey()).withStyle(entry.getColor()), (Component)Component.translatable((String)entry.getBinding().getCategory()));
            this.entry = entry;
        }

        @Override
        public void onUseItem(RadialMenu radialMenu) {
            radialMenu.setVisibility(false);
            radialMenu.clearAnimation();
            Controller controller = Controllable.getController();
            if (controller != null) {
                Controllable.getInputHandler().handleBindingPressed(controller, this.entry.getBinding(), true);
            }
        }

        @Override
        protected void draw(GuiGraphics graphics, Minecraft mc, boolean left, boolean selected, float animation) {
            int offset;
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            int color = selected ? -3355444 : mc.options.getBackgroundColor(0.7f);
            float alpha = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
            float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
            float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
            float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
            float start = left ? -1.0f : 1.0f;
            float end = (left ? -150.0f : 150.0f) * animation;
            poseStack.translate((1.0f - animation) * (float)(left ? -20 : 20), 0.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex(poseStack.last().pose(), start, -15.0f, 0.0f).setColor(red, green, blue, alpha * animation);
            buffer.addVertex(poseStack.last().pose(), start, -14.0f, 0.0f).setColor(red, green, blue, alpha * animation);
            buffer.addVertex(poseStack.last().pose(), end, -14.0f, 0.0f).setColor(red, green, blue, 0.0f);
            buffer.addVertex(poseStack.last().pose(), end, -15.0f, 0.0f).setColor(red, green, blue, 0.0f);
            buffer.addVertex(poseStack.last().pose(), 0.0f, -14.0f, 0.0f).setColor(red, green, blue, alpha * animation);
            buffer.addVertex(poseStack.last().pose(), 0.0f, 14.0f, 0.0f).setColor(red, green, blue, alpha * animation);
            buffer.addVertex(poseStack.last().pose(), end, 14.0f, 0.0f).setColor(red, green, blue, 0.0f);
            buffer.addVertex(poseStack.last().pose(), end, -14.0f, 0.0f).setColor(red, green, blue, 0.0f);
            buffer.addVertex(poseStack.last().pose(), start, 14.0f, 0.0f).setColor(red, green, blue, alpha * animation);
            buffer.addVertex(poseStack.last().pose(), start, 15.0f, 0.0f).setColor(red, green, blue, alpha * animation);
            buffer.addVertex(poseStack.last().pose(), end, 15.0f, 0.0f).setColor(red, green, blue, 0.0f);
            buffer.addVertex(poseStack.last().pose(), end, 14.0f, 0.0f).setColor(red, green, blue, 0.0f);
            MeshData data = buffer.build();
            if (data != null) {
                BufferUploader.drawWithShader((MeshData)data);
            }
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            if (this.label != null) {
                offset = !left ? 5 : -mc.font.width((FormattedText)this.label) - 5;
                graphics.drawString(mc.font, this.label, offset, -10, -1);
            }
            if (this.description != null) {
                offset = !left ? 5 : -mc.font.width((FormattedText)this.description) - 5;
                graphics.drawString(mc.font, this.description, offset, 2, -1);
            }
            poseStack.popPose();
        }
    }
}

