/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Preconditions;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.ITickEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public class RumbleHandler {
    private static RumbleHandler instance;

    @ApiStatus.Internal
    public RumbleHandler() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Only one instance of RumbleHandler is allowed");
        TickEvents.START_PLAYER.register((IFrameworkEvent)((ITickEvent.StartPlayer)this::onUseItem));
        instance = this;
    }

    @ApiStatus.Internal
    public void onDamage(LocalPlayer player, float damage) {
        if (!((Boolean)Config.CLIENT.options.rumble.get()).booleanValue()) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null || !controller.isBeingUsed() || !controller.supportsRumble()) {
            return;
        }
        float scale = damage / player.getMaxHealth();
        float maxFreq = Math.clamp(scale, 0.1f, 1.0f);
        float minFreq = Math.clamp(maxFreq - 0.2f, 0.1f, 1.0f);
        int time = Mth.clamp((int)((int)(scale * 800.0f)), (int)100, (int)800);
        controller.rumble(minFreq, maxFreq, time);
    }

    private void onUseItem(Player player) {
        if (!player.isLocalPlayer()) {
            return;
        }
        if (!((Boolean)Config.CLIENT.options.rumble.get()).booleanValue()) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null || !controller.isBeingUsed() || !controller.supportsRumble()) {
            return;
        }
        if (!player.isUsingItem()) {
            return;
        }
        int ticks = player.getTicksUsingItem();
        ItemStack stack = player.getUseItem();
        switch (stack.getUseAnimation()) {
            case EAT: 
            case DRINK: {
                if (ticks < 4) break;
                float maxFreq = Mth.abs((float)(Mth.cos((float)((float)ticks / 4.0f * (float)Math.PI)) * 0.1f));
                controller.rumble(0.0f, maxFreq, 80);
                break;
            }
            case BLOCK: {
                float maxFreq = Math.min((float)ticks / 3.0f, 1.0f);
                controller.rumble(0.0f, maxFreq *= 0.15f, 80);
                break;
            }
            case BOW: {
                float maxFreq = (float)ticks / 20.0f;
                maxFreq = (maxFreq * maxFreq + maxFreq * 2.0f) / 3.0f;
                maxFreq = Mth.clamp((float)maxFreq, (float)0.0f, (float)1.0f);
                controller.rumble(0.0f, maxFreq *= 0.15f, 80);
                break;
            }
            case SPEAR: {
                float maxFreq = (float)ticks / 10.0f;
                maxFreq = Mth.clamp((float)maxFreq, (float)0.0f, (float)1.0f);
                controller.rumble(0.0f, maxFreq *= 0.15f, 80);
                break;
            }
            case CROSSBOW: {
                if (ticks > 24) break;
                float maxFreq = (float)ticks / 20.0f;
                controller.rumble(0.0f, maxFreq *= 0.15f, 80);
                break;
            }
            case BRUSH: {
                float maxFreq = (float)(ticks % 5) / 5.0f;
                maxFreq = Mth.clamp((float)maxFreq, (float)0.0f, (float)1.0f);
                controller.rumble(0.0f, maxFreq *= 0.2f, 80);
            }
        }
    }
}

