/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Preconditions;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.util.InputHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.ScreenEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IScreenEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import org.jetbrains.annotations.ApiStatus;

public class ScrollingHandler {
    private static ScrollingHandler instance;
    private static final float ABSTRACT_LIST_SCROLL_THRESHOLD = 0.2f;
    private static final float SCROLL_THRESHOLD = 0.4f;
    private long lastScrollTime;
    private boolean initialized;

    @ApiStatus.Internal
    public ScrollingHandler() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Only one instance of ScrollingHandler is allowed");
        instance = this;
    }

    @ApiStatus.Internal
    public void registerEvents() {
        if (!this.initialized) {
            TickEvents.START_RENDER.register((IFrameworkEvent)((ITickEvent.StartRender)this::scrollScreensWithLists));
            ScreenEvents.OPENED.register((IFrameworkEvent)((IScreenEvent.Opened)this::onScreenOpened));
            this.initialized = true;
        }
    }

    private void onScreenOpened(Screen screen) {
        this.lastScrollTime = 0L;
    }

    private void scrollScreensWithLists(DeltaTracker tracker) {
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            if (this.handleAbstractListScrolling(mc.screen, controller)) {
                return;
            }
            this.handleScreenScrolling(mc.screen, controller);
        }
    }

    private void handleScreenScrolling(Screen screen, Controller controller) {
        float input = this.getScrollingInputY(controller);
        if (Math.abs(input) >= 0.4f) {
            int screenCursorX = Controllable.getCursor().getScreenX();
            int screenCursorY = Controllable.getCursor().getScreenY();
            if (this.usePreciseInput(screen)) {
                input = InputHelper.applyDeadzone(input, 0.4f);
                input = this.scaleInputForScreen(screen, input);
                screen.mouseScrolled((double)screenCursorX, (double)screenCursorY, 0.0, (double)(-(input *= Minecraft.getInstance().getTimer().getGameTimeDeltaTicks())));
            } else {
                long scrollTime = Util.getMillis();
                if (scrollTime - this.lastScrollTime >= this.getScrollIntervalInMillis(screen)) {
                    input = Math.signum(input);
                    input = this.scaleInputForScreen(screen, input);
                    screen.mouseScrolled((double)screenCursorX, (double)screenCursorY, 0.0, (double)(-input));
                    this.lastScrollTime = scrollTime;
                }
            }
            controller.updateInputTime();
        } else {
            this.lastScrollTime = 0L;
        }
    }

    private long getScrollIntervalInMillis(Screen screen) {
        Screen screen2 = screen;
        Objects.requireNonNull(screen2);
        Screen screen3 = screen2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MerchantScreen.class, LoomScreen.class, StonecutterScreen.class, CreativeModeInventoryScreen.class}, (Object)screen3, n)) {
            case 0 -> {
                MerchantScreen s = (MerchantScreen)screen3;
                yield 150L;
            }
            case 1 -> {
                LoomScreen s = (LoomScreen)screen3;
                yield 100L;
            }
            case 2 -> {
                StonecutterScreen s = (StonecutterScreen)screen3;
                yield 120L;
            }
            case 3 -> {
                CreativeModeInventoryScreen s = (CreativeModeInventoryScreen)screen3;
                yield 65L;
            }
            default -> 50L;
        };
    }

    private boolean usePreciseInput(Screen screen) {
        Screen screen2 = screen;
        Objects.requireNonNull(screen2);
        Screen screen3 = screen2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdvancementsScreen.class}, (Object)screen3, n)) {
            case 0 -> {
                AdvancementsScreen s = (AdvancementsScreen)screen3;
                yield true;
            }
            default -> false;
        };
    }

    private float scaleInputForScreen(Screen screen, float input) {
        Screen screen2 = screen;
        Objects.requireNonNull(screen2);
        Screen screen3 = screen2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChatScreen.class}, (Object)screen3, n)) {
            case 0 -> {
                ChatScreen s = (ChatScreen)screen3;
                yield Math.signum(input) * 0.15f;
            }
            default -> input;
        };
    }

    private boolean handleAbstractListScrolling(Screen screen, Controller controller) {
        double cursorY;
        double cursorX;
        GuiEventListener hoveredListener;
        float input = this.getScrollingInputY(controller);
        if (Math.abs(input) >= 0.2f && (hoveredListener = (GuiEventListener)ScreenHelper.findHoveredListener(screen, cursorX = Controllable.getCursor().getRenderScreenX(), cursorY = Controllable.getCursor().getRenderScreenY(), listener -> listener instanceof AbstractSelectionList).orElse(null)) instanceof AbstractSelectionList) {
            AbstractSelectionList list = (AbstractSelectionList)hoveredListener;
            double direction = InputHelper.applyDeadzone(input, 0.2f);
            list.setScrollAmount(list.getScrollAmount() + (direction *= (double)Minecraft.getInstance().getTimer().getGameTimeDeltaTicks()) * (Double)Config.CLIENT.options.listScrollSpeed.get());
            controller.updateInputTime();
            return true;
        }
        return false;
    }

    private float getScrollingInputY(Controller controller) {
        float up = controller.getPressedValue(ButtonBindings.SCROLL_UP.getButton());
        float down = controller.getPressedValue(ButtonBindings.SCROLL_DOWN.getButton());
        if (up > 0.0f && down > 0.0f) {
            return 0.0f;
        }
        return -up + down;
    }
}

