/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Preconditions;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.util.InputHelper;
import com.mrcrayfish.controllable.client.util.MouseHooks;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.controllable.mixin.client.TimerAccessor;
import com.mrcrayfish.controllable.platform.ClientServices;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.ScreenEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IScreenEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector2f;

public final class VirtualCursor {
    private static volatile VirtualCursor instance;
    private final Vector2f inputVector = new Vector2f();
    private int prevX;
    private int prevY;
    private int x;
    private int y;
    private double renderX;
    private double renderY;
    private boolean visible;
    private boolean snapIfNoMove;
    private boolean initialized;
    private CursorMode mode = CursorMode.CONTROLLER;

    @ApiStatus.Internal
    public VirtualCursor() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Only one instance of VirtualCursor is allowed");
        instance = this;
    }

    @ApiStatus.Internal
    public void registerEvents() {
        if (!this.initialized) {
            TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)this::updateMovement));
            TickEvents.START_RENDER.register((IFrameworkEvent)((ITickEvent.StartRender)this::updateRenderPosition));
            ScreenEvents.OPENED.register((IFrameworkEvent)((IScreenEvent.Opened)this::onScreenOpened));
            this.initialized = true;
        }
    }

    @ApiStatus.Internal
    public void resetToCenter() {
        Minecraft mc = Minecraft.getInstance();
        this.x = this.prevX = mc.getWindow().getScreenWidth() / 2;
        this.renderX = this.prevX;
        this.y = this.prevY = mc.getWindow().getScreenHeight() / 2;
        this.renderY = this.prevY;
    }

    public boolean isEnabled() {
        return (Boolean)Config.CLIENT.options.disableVirtualCursor.get() == false;
    }

    public boolean isVisible() {
        return this.mode.isController() && this.visible;
    }

    @ApiStatus.Internal
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getScreenX() {
        Minecraft mc = Minecraft.getInstance();
        return (int)((double)this.x * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getWidth());
    }

    public int getScreenY() {
        Minecraft mc = Minecraft.getInstance();
        return (int)((double)this.y * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getHeight());
    }

    public double getRenderX() {
        return this.renderX;
    }

    public double getRenderY() {
        return this.renderY;
    }

    public double getRenderScreenX() {
        Minecraft mc = Minecraft.getInstance();
        return this.renderX * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getWidth();
    }

    public double getRenderScreenY() {
        Minecraft mc = Minecraft.getInstance();
        return this.renderY * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getHeight();
    }

    public CursorMode getMode() {
        return this.mode;
    }

    @ApiStatus.Internal
    public void setMode(CursorMode mode) {
        this.mode = mode;
    }

    private void updateMovement() {
        if (!this.isEnabled()) {
            return;
        }
        this.prevX = this.x;
        this.prevY = this.y;
        this.inputVector.zero();
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen == null || mc.screen instanceof ControllerLayoutScreen) {
            return;
        }
        this.updateInputVector(controller);
        if (this.inputVector.lengthSquared() > 0.0f) {
            double cursorSpeed = (Double)Config.CLIENT.options.cursorSpeed.get() * Math.max(mc.getWindow().getGuiScale(), 1.0);
            if (this.isHoveringContainerSlot() || this.isHoveringEventListener()) {
                cursorSpeed *= ((Double)Config.CLIENT.options.hoverModifier.get()).doubleValue();
            }
            this.x += (int)((double)this.inputVector.x * cursorSpeed);
            this.y += (int)((double)this.inputVector.y * cursorSpeed);
            this.clampCursorToWindowBounds();
            this.setVisible(true);
            controller.updateInputTime();
            this.snapIfNoMove = true;
            this.mode = CursorMode.CONTROLLER;
        } else if (this.snapIfNoMove) {
            this.snapToContainerSlot();
            this.snapIfNoMove = false;
        }
        if (this.x != this.prevX || this.y != this.prevY) {
            MouseHooks.invokeMouseMoved(mc.screen, this.x, this.y, this.x - this.prevX, this.y - this.prevY);
        }
    }

    private void updateRenderPosition(DeltaTracker tracker) {
        if (!this.isEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen == null) {
            return;
        }
        if (this.x == this.prevX && this.y == this.prevY) {
            this.renderX = this.x;
            this.renderY = this.y;
            return;
        }
        float partialTick = this.getPartialTick(tracker);
        this.renderX = (float)this.prevX + (float)(this.x - this.prevX) * partialTick;
        this.renderY = (float)this.prevY + (float)(this.y - this.prevY) * partialTick;
    }

    private float getPartialTick(DeltaTracker tracker) {
        if (tracker instanceof TimerAccessor) {
            TimerAccessor accessor = (TimerAccessor)tracker;
            return accessor.controllable$DeltaTickResidual();
        }
        return tracker.getGameTimeDeltaPartialTick(true);
    }

    private void onScreenOpened(Screen screen) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return;
        }
        this.x = this.prevX = mc.getWindow().getScreenWidth() / 2;
        this.renderX = this.prevX;
        this.y = this.prevY = mc.getWindow().getScreenHeight() / 2;
        this.renderY = this.prevY;
        this.setVisible(true);
    }

    private void updateInputVector(Controller controller) {
        float moveThreshold = 0.35f;
        float thumbstickX = this.getCursorInputX(controller);
        float thumbstickY = this.getCursorInputY(controller);
        float cursorVectorX = Math.abs(thumbstickX) >= moveThreshold ? thumbstickX : 0.0f;
        float cursorVectorY = Math.abs(thumbstickY) >= moveThreshold ? thumbstickY : 0.0f;
        this.inputVector.x = InputHelper.applyDeadzone(cursorVectorX, moveThreshold);
        this.inputVector.y = InputHelper.applyDeadzone(cursorVectorY, moveThreshold);
    }

    private void clampCursorToWindowBounds() {
        Minecraft mc = Minecraft.getInstance();
        this.x = Math.max(0, Math.min(this.x, mc.getWindow().getWidth()));
        this.y = Math.max(0, Math.min(this.y, mc.getWindow().getHeight()));
    }

    private float getCursorInputX(Controller controller) {
        float left = controller.getPressedValue(ButtonBindings.MOVE_CURSOR_LEFT.getButton());
        float right = controller.getPressedValue(ButtonBindings.MOVE_CURSOR_RIGHT.getButton());
        if (left > 0.0f && right > 0.0f) {
            return 0.0f;
        }
        return -left + right;
    }

    private float getCursorInputY(Controller controller) {
        float up = controller.getPressedValue(ButtonBindings.MOVE_CURSOR_UP.getButton());
        float down = controller.getPressedValue(ButtonBindings.MOVE_CURSOR_DOWN.getButton());
        if (up > 0.0f && down > 0.0f) {
            return 0.0f;
        }
        return down - up;
    }

    private boolean isHoveringContainerSlot() {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            return ClientServices.CLIENT.getSlotUnderMouse(screen2) != null;
        }
        return false;
    }

    private boolean isHoveringEventListener() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen == null) {
            return false;
        }
        double cursorScreenX = (double)this.x * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getWidth();
        double cursorScreenY = (double)this.y * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getHeight();
        return ScreenHelper.findHoveredEventListenerExcludeList((ContainerEventHandler)mc.screen, cursorScreenX, cursorScreenY).isPresent();
    }

    public void jumpCursorTo(int x, int y) {
        this.x = x;
        this.y = y;
        this.clampCursorToWindowBounds();
        this.prevX = this.x;
        this.renderX = this.prevX;
        this.prevY = this.y;
        this.renderY = this.prevY;
    }

    private void snapToContainerSlot() {
        AbstractContainerScreen screen;
        Slot slot;
        Screen screen2;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (screen2 = mc.screen) instanceof AbstractContainerScreen && (slot = ClientServices.CLIENT.getSlotUnderMouse(screen = (AbstractContainerScreen)screen2)) != null && slot.isActive() && (slot.hasItem() || !screen.getMenu().getCarried().isEmpty())) {
            int slotX = ClientServices.CLIENT.getScreenLeft(screen) + slot.x + 8;
            int slotY = ClientServices.CLIENT.getScreenTop(screen) + slot.y + 8;
            this.x = slotX *= (int)mc.getWindow().getGuiScale();
            this.y = slotY *= (int)mc.getWindow().getGuiScale();
            this.clampCursorToWindowBounds();
        }
    }

    public static enum CursorMode {
        CONTROLLER,
        MOUSE;


        public boolean isController() {
            return this == CONTROLLER;
        }

        public boolean isMouse() {
            return this == MOUSE;
        }
    }
}

