/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.MoreFiles;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mrcrayfish.controllable.Constants;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.binding.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.input.Buttons;
import com.mrcrayfish.controllable.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BindingRegistry {
    private static BindingRegistry instance;
    private static final Gson GSON;
    private final List<ButtonBinding> bindings = new ArrayList<ButtonBinding>();
    private final Map<String, ButtonBinding> registeredBindings = new HashMap<String, ButtonBinding>();
    private final Map<String, KeyAdapterBinding> keyAdapters = new HashMap<String, KeyAdapterBinding>();
    private final Multimap<Integer, ButtonBinding> idToButtonList = TreeMultimap.create((Comparator)Ordering.natural(), Comparator.comparing(binding -> binding.getContext().priority()).reversed().thenComparing(ButtonBinding::compareTo));

    public BindingRegistry() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Only one instance of BindingRegistry is allowed");
        this.registerBuiltinBindings();
        instance = this;
    }

    private void registerBuiltinBindings() {
        this.register(ButtonBindings.JUMP);
        this.register(ButtonBindings.SNEAK);
        this.register(ButtonBindings.SPRINT);
        this.register(ButtonBindings.OPEN_INVENTORY);
        this.register(ButtonBindings.CLOSE_INVENTORY);
        this.register(ButtonBindings.SWAP_HANDS);
        this.register(ButtonBindings.DROP_ITEM);
        this.register(ButtonBindings.USE_ITEM);
        this.register(ButtonBindings.ATTACK);
        this.register(ButtonBindings.PICK_BLOCK);
        this.register(ButtonBindings.PLAYER_LIST);
        this.register(ButtonBindings.TOGGLE_PERSPECTIVE);
        this.register(ButtonBindings.SCREENSHOT);
        this.register(ButtonBindings.SCROLL_HOTBAR_LEFT);
        this.register(ButtonBindings.SCROLL_HOTBAR_RIGHT);
        this.register(ButtonBindings.PAUSE_GAME);
        this.register(ButtonBindings.UNPAUSE_GAME);
        this.register(ButtonBindings.NEXT_CREATIVE_TAB);
        this.register(ButtonBindings.PREVIOUS_CREATIVE_TAB);
        this.register(ButtonBindings.NEXT_RECIPE_TAB);
        this.register(ButtonBindings.PREVIOUS_RECIPE_TAB);
        this.register(ButtonBindings.NAVIGATE_UP);
        this.register(ButtonBindings.NAVIGATE_DOWN);
        this.register(ButtonBindings.NAVIGATE_LEFT);
        this.register(ButtonBindings.NAVIGATE_RIGHT);
        this.register(ButtonBindings.PICKUP_ITEM);
        this.register(ButtonBindings.QUICK_MOVE);
        this.register(ButtonBindings.SPLIT_STACK);
        this.register(ButtonBindings.SOCIAL_INTERACTIONS);
        this.register(ButtonBindings.ADVANCEMENTS);
        this.register(ButtonBindings.HIGHLIGHT_PLAYERS);
        this.register(ButtonBindings.CINEMATIC_CAMERA);
        this.register(ButtonBindings.FULLSCREEN);
        this.register(ButtonBindings.DEBUG_INFO);
        this.register(ButtonBindings.RADIAL_MENU);
        this.register(ButtonBindings.HOTBAR_SLOT_1);
        this.register(ButtonBindings.HOTBAR_SLOT_2);
        this.register(ButtonBindings.HOTBAR_SLOT_3);
        this.register(ButtonBindings.HOTBAR_SLOT_4);
        this.register(ButtonBindings.HOTBAR_SLOT_5);
        this.register(ButtonBindings.HOTBAR_SLOT_6);
        this.register(ButtonBindings.HOTBAR_SLOT_7);
        this.register(ButtonBindings.HOTBAR_SLOT_8);
        this.register(ButtonBindings.HOTBAR_SLOT_9);
        this.register(ButtonBindings.TOGGLE_CRAFT_BOOK);
        this.register(ButtonBindings.OPEN_CONTROLLABLE_SETTINGS);
        this.register(ButtonBindings.OPEN_CHAT);
        this.register(ButtonBindings.MOVE_CURSOR_UP);
        this.register(ButtonBindings.MOVE_CURSOR_DOWN);
        this.register(ButtonBindings.MOVE_CURSOR_LEFT);
        this.register(ButtonBindings.MOVE_CURSOR_RIGHT);
        this.register(ButtonBindings.SCROLL_UP);
        this.register(ButtonBindings.SCROLL_DOWN);
        this.register(ButtonBindings.WALK_FORWARDS);
        this.register(ButtonBindings.WALK_BACKWARDS);
        this.register(ButtonBindings.STRAFE_LEFT);
        this.register(ButtonBindings.STRAFE_RIGHT);
        this.register(ButtonBindings.LOOK_UP);
        this.register(ButtonBindings.LOOK_DOWN);
        this.register(ButtonBindings.LOOK_LEFT);
        this.register(ButtonBindings.LOOK_RIGHT);
    }

    public List<ButtonBinding> getRegisteredBindings() {
        return this.bindings;
    }

    public Collection<ButtonBinding> getBindingsForButton(int button) {
        return this.idToButtonList.get((Object)button);
    }

    @Nullable
    public ButtonBinding getBindingByDescriptionKey(String key) {
        return Stream.concat(this.registeredBindings.values().stream(), this.keyAdapters.values().stream()).filter(binding -> binding.getDescription().equals(key)).findFirst().orElse(null);
    }

    public List<ButtonBinding> getBindings() {
        return ImmutableList.copyOf(this.bindings);
    }

    public Map<String, KeyAdapterBinding> getKeyAdapters() {
        return this.keyAdapters;
    }

    @Nullable
    public KeyAdapterBinding getKeyAdapterByDescriptionKey(String key) {
        return this.keyAdapters.get(key);
    }

    public void register(ButtonBinding binding) {
        Preconditions.checkArgument((!(binding instanceof KeyAdapterBinding) ? 1 : 0) != 0, (Object)"A key adapter binding can not be registered");
        if (this.registeredBindings.putIfAbsent(binding.getDescription(), binding) == null) {
            this.bindings.add(binding);
            if (!binding.isUnbound()) {
                this.idToButtonList.put((Object)binding.getButton(), (Object)binding);
            }
        }
    }

    public void addKeyAdapter(KeyAdapterBinding binding) {
        if (this.keyAdapters.putIfAbsent(binding.getDescription(), binding) == null) {
            this.bindings.add(binding);
            if (!binding.isUnbound()) {
                this.idToButtonList.put((Object)binding.getButton(), (Object)binding);
            }
            this.save();
        }
    }

    public void removeKeyAdapter(KeyAdapterBinding binding) {
        if (this.bindings.remove(binding)) {
            this.keyAdapters.remove(binding.getDescription());
            this.idToButtonList.remove((Object)binding.getButton(), (Object)binding);
            this.save();
        }
    }

    public void rebuildCache() {
        Controllable.getInputHandler().clearActiveHandlers();
        this.idToButtonList.clear();
        this.bindings.stream().filter(binding -> !binding.isUnbound()).forEach(binding -> this.idToButtonList.put((Object)binding.getButton(), binding));
    }

    public void completeSetup() {
        block20: {
            BufferedReader reader;
            Path path;
            block19: {
                try {
                    path = Utils.getConfigDirectory().resolve("controllable").resolve("bindings.json");
                    MoreFiles.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        reader = Files.newBufferedReader(path);
                        try {
                            JsonObject adapters = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                            this.registeredBindings.values().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
                                JsonPrimitive value;
                                String description = binding.getDescription();
                                JsonElement patt0$temp = adapters.get(description);
                                if (patt0$temp instanceof JsonPrimitive && (value = (JsonPrimitive)patt0$temp).isString()) {
                                    ButtonBinding.setButton(binding, Buttons.getButtonFromName(value.getAsString()));
                                }
                            });
                            break block19;
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                    }
                    Constants.LOG.info("Skipped loading bindings.properties since it doesn't exist");
                }
                catch (IOException e) {
                    Constants.LOG.error("Failed to load bindings.properties", (Throwable)e);
                }
            }
            try {
                path = Utils.getConfigDirectory().resolve("controllable").resolve("key_adapters.json");
                MoreFiles.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    reader = Files.newBufferedReader(path);
                    try {
                        HashMap<String, KeyMapping> bindings = new HashMap<String, KeyMapping>();
                        for (KeyMapping mapping : Minecraft.getInstance().options.keyMappings) {
                            bindings.put(mapping.getName(), mapping);
                        }
                        JsonObject adapters = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        adapters.asMap().forEach((key, element) -> {
                            int button;
                            KeyAdapterBinding keyAdapter;
                            JsonPrimitive value;
                            if (!(element instanceof JsonPrimitive) || !(value = (JsonPrimitive)element).isString()) {
                                return;
                            }
                            KeyMapping mapping = (KeyMapping)bindings.get(key);
                            if (mapping != null && this.keyAdapters.putIfAbsent((keyAdapter = new KeyAdapterBinding(button = Buttons.getButtonFromName((String)StringUtils.defaultIfEmpty((CharSequence)element.getAsString(), (CharSequence)"")), mapping)).getDescription(), keyAdapter) == null) {
                                this.bindings.add(keyAdapter);
                                if (!keyAdapter.isUnbound()) {
                                    this.idToButtonList.put((Object)keyAdapter.getButton(), (Object)keyAdapter);
                                }
                            }
                        });
                        break block20;
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                Constants.LOG.info("Skipped loading key_adapters.properties since it doesn't exist");
            }
            catch (IOException e) {
                Constants.LOG.error("Failed to load key_adapters.properties", (Throwable)e);
            }
        }
        this.rebuildCache();
    }

    public void save() {
        Path path;
        String json;
        try {
            JsonObject bindings = new JsonObject();
            this.registeredBindings.values().stream().filter(ButtonBinding::isNotReserved).sorted(Comparator.comparing(ButtonBinding::getDescription)).forEach(binding -> {
                String name = (String)StringUtils.defaultIfEmpty((CharSequence)Buttons.getNameForButton(binding.getButton()), (CharSequence)"");
                bindings.addProperty(binding.getDescription(), name);
            });
            json = GSON.toJson((JsonElement)bindings);
            path = Utils.getConfigDirectory().resolve("controllable").resolve("bindings.json");
            MoreFiles.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to save bindings.json", (Throwable)e);
        }
        try {
            JsonObject adapters = new JsonObject();
            this.keyAdapters.values().stream().filter(ButtonBinding::isNotReserved).sorted(Comparator.comparing(ButtonBinding::getDescription)).forEach(binding -> {
                String name = (String)StringUtils.defaultIfEmpty((CharSequence)Buttons.getNameForButton(binding.getButton()), (CharSequence)"");
                adapters.addProperty(binding.getKeyMapping().getName(), name);
            });
            json = GSON.toJson((JsonElement)adapters);
            path = Utils.getConfigDirectory().resolve("controllable").resolve("key_adapters.json");
            MoreFiles.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to save key_adapters.json", (Throwable)e);
        }
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public static BindingRegistry getInstance() {
        return Controllable.getBindingRegistry();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

