/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.binding;

import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.handlers.EmptyHandler;
import com.mrcrayfish.controllable.platform.ClientServices;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public final class KeyAdapterBinding
extends ButtonBinding {
    private final KeyMapping keyMapping;
    private final String labelKey;

    public KeyAdapterBinding(int button, KeyMapping mapping) {
        super(button, mapping.getName() + ".custom", "key.categories.controllable_custom", ClientServices.CLIENT.createBindingContext(mapping), EmptyHandler.INSTANCE);
        this.keyMapping = mapping;
        this.labelKey = mapping.getName();
    }

    @Override
    public String getLabelKey() {
        return this.labelKey;
    }

    public KeyMapping getKeyMapping() {
        return this.keyMapping;
    }

    @Override
    protected void setPressed(boolean pressed) {
        boolean wasPressed = this.isButtonDown();
        super.setPressed(pressed);
        this.keyMapping.setDown(pressed);
        if (!wasPressed && pressed) {
            this.updateKeyBindPressTime();
            int key = ClientServices.CLIENT.getKeyValue(this.keyMapping);
            this.handlePressed(1, key, 0);
        } else if (wasPressed && !pressed) {
            int key = ClientServices.CLIENT.getKeyValue(this.keyMapping);
            this.handlePressed(0, key, 0);
        }
    }

    private void updateKeyBindPressTime() {
        ClientServices.CLIENT.setKeyPressTime(this.keyMapping, 1);
    }

    private void handlePressed(int action, int key, int modifiers) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen != null && ClientServices.CLIENT.sendScreenInput(screen, key, action, modifiers)) {
            return;
        }
        ClientServices.CLIENT.sendKeyInputEvent(key, 0, action, modifiers);
    }
}

