/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.binding.context;

import com.google.common.base.Preconditions;
import com.mrcrayfish.controllable.client.binding.context.rule.ContextRule;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public abstract class BindingContext {
    private static final Set<ResourceLocation> REGISTERED_CONTEXTS = Collections.synchronizedSet(new HashSet());
    private static final Map<ConflictKey, Boolean> CONFLICT_CACHE = new HashMap<ConflictKey, Boolean>();
    private final ResourceLocation id;
    private Set<ContextRule> rules;

    BindingContext(ResourceLocation id) {
        Preconditions.checkState((boolean)REGISTERED_CONTEXTS.add(id), (Object)"Duplicate binding context id: %s".formatted(id));
        this.id = id;
    }

    protected abstract Set<ContextRule> createRules();

    public final Set<ContextRule> rules() {
        if (this.rules == null) {
            this.rules = this.createRules();
        }
        return this.rules;
    }

    public final boolean isActive() {
        Set<ContextRule> rules = this.rules();
        return rules.isEmpty() || rules.stream().allMatch(ContextRule::isActive);
    }

    public final boolean conflicts(BindingContext other) {
        return CONFLICT_CACHE.computeIfAbsent(ConflictKey.of(this, other), key -> {
            if (this.priority() != other.priority()) {
                return false;
            }
            return BindingContext.doAllRulesMatch(this.rules(), other.rules());
        });
    }

    public abstract int priority();

    public int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof BindingContext)) {
            return false;
        }
        BindingContext that = (BindingContext)o;
        return this.id.equals((Object)that.id);
    }

    private static boolean doAllRulesMatch(Set<ContextRule> a, Set<ContextRule> b) {
        return a.isEmpty() || b.isEmpty() || a.stream().allMatch(r1 -> b.stream().anyMatch(r2 -> r2.matches((ContextRule)r1))) || b.stream().allMatch(r1 -> a.stream().anyMatch(r2 -> r2.matches((ContextRule)r1)));
    }

    public record ConflictKey(BindingContext first, BindingContext second) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            BindingContext a;
            BindingContext bindingContext;
            if (!(o instanceof ConflictKey)) return false;
            ConflictKey conflictKey = (ConflictKey)o;
            try {
                a = bindingContext = conflictKey.first();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            BindingContext b = bindingContext = conflictKey.second();
            if (!Objects.equals(this.first, a)) return false;
            if (!Objects.equals(this.second, b)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public static ConflictKey of(BindingContext first, BindingContext second) {
            int result = first.id.compareTo(second.id);
            return new ConflictKey(result >= 0 ? first : second, result >= 0 ? second : first);
        }
    }
}

