/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.binding.context;

import com.mrcrayfish.controllable.client.binding.context.BindingContext;
import com.mrcrayfish.controllable.client.binding.context.rule.ContextRule;
import com.mrcrayfish.controllable.client.binding.context.rule.HasPlayerRule;
import com.mrcrayfish.controllable.client.binding.context.rule.HasScreenRule;
import com.mrcrayfish.controllable.client.binding.context.rule.NoScreenRule;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;

public class NeoForgeKeyContext
extends BindingContext {
    private final IKeyConflictContext context;

    public NeoForgeKeyContext(IKeyConflictContext context) {
        super(NeoForgeKeyContext.generateId(context));
        this.context = context;
    }

    @Override
    public Set<ContextRule> createRules() {
        return NeoForgeKeyContext.generateRules(this.context);
    }

    @Override
    public int priority() {
        return 0;
    }

    private static ResourceLocation generateId(IKeyConflictContext context) {
        if (context == KeyConflictContext.UNIVERSAL) {
            return ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"universal");
        }
        if (context == KeyConflictContext.GUI) {
            return ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"gui");
        }
        if (context == KeyConflictContext.IN_GAME) {
            return ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"in_game");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)UUID.randomUUID().toString());
    }

    private static Set<ContextRule> generateRules(IKeyConflictContext context) {
        if (context == KeyConflictContext.GUI) {
            return Set.of(HasScreenRule.any());
        }
        if (context == KeyConflictContext.IN_GAME) {
            return Set.of(NoScreenRule.get(), HasPlayerRule.get());
        }
        return Set.of();
    }
}

