/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.binding.context.rule;

import com.mrcrayfish.controllable.client.binding.context.rule.ContextRule;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public final class HasScreenRule
extends ContextRule {
    private final Set<Class<? extends Screen>> validScreens;

    private HasScreenRule(Set<Class<? extends Screen>> validScreens) {
        this.validScreens = Set.copyOf(validScreens);
    }

    @Override
    public boolean isActive() {
        Minecraft mc = Minecraft.getInstance();
        return mc.screen != null && (this.validScreens.isEmpty() || this.validScreens.contains(mc.screen.getClass()));
    }

    @Override
    public boolean matches(ContextRule other) {
        if (!(other instanceof HasScreenRule)) {
            return false;
        }
        HasScreenRule that = (HasScreenRule)other;
        if (this.validScreens.isEmpty()) {
            return true;
        }
        if (that.validScreens.isEmpty()) {
            return true;
        }
        return !Collections.disjoint(this.validScreens, that.validScreens);
    }

    public static HasScreenRule any() {
        return new HasScreenRule(Set.of());
    }

    public static HasScreenRule of(Set<Class<? extends Screen>> screenClasses) {
        return new HasScreenRule(screenClasses);
    }

    public int hashCode() {
        return HasScreenRule.class.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == HasScreenRule.class;
    }
}

