/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ISearchable;
import com.mrcrayfish.controllable.client.gui.Icons;
import com.mrcrayfish.controllable.client.gui.components.TabOptionBaseItem;
import com.mrcrayfish.controllable.client.gui.components.TabSelectionList;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.screens.SelectKeyBindingScreen;
import com.mrcrayfish.controllable.client.gui.screens.SettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ButtonBindingButton;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetTooltipHolder;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ButtonBindingList
extends TabSelectionList<TabSelectionList.BaseItem> {
    private final SettingsScreen settingsScreen;
    protected Map<String, List<ButtonBinding>> categories = new LinkedHashMap<String, List<ButtonBinding>>();

    public ButtonBindingList(SettingsScreen settingsScreen, Minecraft mc, int itemHeight) {
        super(mc, itemHeight);
        this.settingsScreen = settingsScreen;
        this.categories.put("key.categories.controllable_custom", new ArrayList());
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
        this.repopulateBindings(false);
    }

    private void repopulateBindings(boolean showUnbound) {
        this.clearEntries();
        MutableComponent addKeybind = ClientHelper.join(Icons.KEY_CAP, (Component)Component.translatable((String)"controllable.gui.add_key_bind"));
        MutableComponent restoreDefaults = ClientHelper.join(Icons.RESET, (Component)Component.translatable((String)"controllable.gui.restore_defaults"));
        this.addEntry(new TwoWidgetItem((AbstractWidget)Button.builder((Component)addKeybind, btn -> this.minecraft.setScreen((Screen)new SelectKeyBindingScreen(this.settingsScreen, () -> this.repopulateBindings(false)))).build(), (AbstractWidget)Button.builder((Component)restoreDefaults, btn -> this.minecraft.setScreen((Screen)new ConfirmationScreen(this.settingsScreen, (Component)Component.translatable((String)"controllable.gui.reset_selected_bindings"), result -> {
            if (result.booleanValue()) {
                BindingRegistry registry = Controllable.getBindingRegistry();
                registry.getBindings().forEach(ButtonBinding::resetMappedButton);
                registry.rebuildCache();
                registry.save();
            }
            return true;
        }))).build()));
        this.categories.forEach((category, list) -> list.clear());
        Controllable.getBindingRegistry().getBindings().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
            if (showUnbound && !binding.isUnbound()) {
                return;
            }
            List list = this.categories.computeIfAbsent(binding.getCategory(), category -> new ArrayList());
            list.add(binding);
        });
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                this.addEntry(new TabSelectionList.TitleItem((TabSelectionList)this, (Component)Component.translatable((String)category).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
                list.forEach(binding -> this.addEntry(new ButtonBindingItem((ButtonBinding)binding)));
            }
        });
    }

    public static class TwoWidgetItem
    extends TabSelectionList.BaseItem {
        private final AbstractWidget leftWidget;
        private final AbstractWidget rightWidget;

        public TwoWidgetItem(AbstractWidget leftWidget, AbstractWidget rightWidget) {
            super(CommonComponents.EMPTY);
            this.leftWidget = leftWidget;
            this.rightWidget = rightWidget;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.leftWidget.setWidth(width / 2 - 10);
            this.leftWidget.setX(left + 5);
            this.leftWidget.setY(top);
            this.leftWidget.render(graphics, mouseX, mouseY, partialTick);
            this.rightWidget.setWidth(width / 2 - 10);
            this.rightWidget.setX(left + width / 2 + 5);
            this.rightWidget.setY(top);
            this.rightWidget.render(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.leftWidget, (Object)this.rightWidget);
        }
    }

    public class ButtonBindingItem
    extends TabOptionBaseItem
    implements ISearchable {
        private final ButtonBinding binding;
        private final Button bindingButton;
        private final Button resetButton;
        private final WidgetTooltipHolder tooltip;

        protected ButtonBindingItem(ButtonBinding binding) {
            super((Component)Component.translatable((String)binding.getLabelKey()));
            this.tooltip = new WidgetTooltipHolder();
            this.binding = binding;
            this.tooltip.setDelay(Duration.ofMillis(400L));
            this.bindingButton = new ButtonBindingButton(0, 0, binding, button -> {
                if (button == 0) {
                    ButtonBindingList.this.settingsScreen.setSelectedBinding(this.binding);
                    return true;
                }
                if (button == 1) {
                    ButtonBinding.setButton(this.binding, -1);
                    BindingRegistry registry = Controllable.getBindingRegistry();
                    registry.rebuildCache();
                    registry.save();
                    return true;
                }
                return false;
            });
            this.resetButton = new ImageButton(0, 0, 20, Icons.TEXTURE, 44, 0, 11, 11, Icons.TEXTURE_WIDTH, 11, button -> {
                binding.resetMappedButton();
                BindingRegistry registry = Controllable.getBindingRegistry();
                registry.rebuildCache();
                registry.save();
            });
        }

        private List<Component> getBindingTooltip(ButtonBinding binding) {
            Controller controller = Controllable.getController();
            if (controller != null && controller.isBeingUsed()) {
                ArrayList<Component> components = new ArrayList<Component>();
                components.add((Component)Component.translatable((String)"controllable.gui.change_binding", (Object[])new Object[]{ClientHelper.getButtonComponent(0)}).withStyle(ChatFormatting.YELLOW));
                if (!binding.isUnbound()) {
                    components.add((Component)Component.translatable((String)"controllable.gui.clear_binding", (Object[])new Object[]{ClientHelper.getButtonComponent(2)}).withStyle(ChatFormatting.YELLOW));
                }
                return components;
            }
            ArrayList<Component> components = new ArrayList<Component>();
            components.add((Component)Component.translatable((String)"controllable.gui.change_binding", (Object[])new Object[]{InputConstants.Type.MOUSE.getOrCreate(0).getDisplayName().copy().withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.YELLOW));
            if (!binding.isUnbound()) {
                components.add((Component)Component.translatable((String)"controllable.gui.clear_binding", (Object[])new Object[]{InputConstants.Type.MOUSE.getOrCreate(1).getDisplayName().copy().withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.YELLOW));
            }
            return components;
        }

        @Override
        public Component getLabel() {
            return this.label;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.bindingButton, (Object)this.resetButton);
        }

        @Override
        public void render(GuiGraphics graphics, int index, int top, int left, int width, int itemHeight, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.updateTooltip(mouseX, mouseY);
            this.setLabelColor(this.binding.isConflictingContext() ? ChatFormatting.RED.getColor() : ChatFormatting.WHITE.getColor());
            super.render(graphics, index, top, left, width, itemHeight, mouseX, mouseY, selected, partialTick);
            this.bindingButton.setTooltip(ClientHelper.createListTooltip(this.getBindingTooltip(this.binding)));
            this.bindingButton.setTooltipDelay(Duration.ofMillis(400L));
            this.bindingButton.setX(left + width - 65);
            this.bindingButton.setY(top);
            this.bindingButton.render(graphics, mouseX, mouseY, partialTick);
            this.resetButton.setX(left + width - 24);
            this.resetButton.setY(top);
            this.resetButton.active = !this.binding.isDefault();
            this.resetButton.render(graphics, mouseX, mouseY, partialTick);
        }

        private void updateTooltip(double mouseX, double mouseY) {
            Controller controller = Controllable.getController();
            if (!this.bindingButton.isHovered() && !this.resetButton.isHovered() && this.isMouseOver(mouseX, mouseY) && controller != null && controller.isBeingUsed()) {
                this.tooltip.set(ClientHelper.createListTooltip(this.getBindingTooltip(this.binding)));
            } else {
                this.tooltip.set(null);
            }
            this.tooltip.refreshTooltipForNextRenderPass(true, false, this.getRectangle());
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            Controller controller = Controllable.getController();
            if (!this.resetButton.isHovered() && controller != null && controller.isBeingUsed()) {
                this.bindingButton.mouseClicked((double)this.bindingButton.getX(), (double)this.bindingButton.getY(), button);
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput output) {
                    output.add(NarratedElementType.TITLE, ButtonBindingItem.this.label);
                }
            });
        }
    }

    public static class OneWidgetItem
    extends TabSelectionList.BaseItem {
        private final AbstractWidget widget;

        public OneWidgetItem(AbstractWidget widget) {
            super(CommonComponents.EMPTY);
            this.widget = widget;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.widget.setWidth(width - 10);
            this.widget.setX(left + 5);
            this.widget.setY(top);
            this.widget.render(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.widget);
        }
    }
}

