/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.gui.components.TabOptionBaseItem;
import com.mrcrayfish.controllable.client.gui.navigation.Navigatable;
import com.mrcrayfish.controllable.client.gui.widget.LazySlider;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.framework.api.config.DoubleProperty;
import com.mrcrayfish.framework.api.config.validate.NumberRange;
import com.mrcrayfish.framework.api.config.validate.Validator;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class TabOptionSliderItem
extends TabOptionBaseItem
implements Navigatable {
    private final LazySlider slider;
    private long lastChange;
    private boolean save;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TabOptionSliderItem(DoubleProperty property, double stepSize) {
        super((Component)Component.translatable((String)property.getTranslationKey()));
        Double minValue;
        Double d;
        Validator validator = property.getValidator();
        if (!(validator instanceof NumberRange)) throw new IllegalArgumentException("Double property must have a number range");
        NumberRange numberRange = (NumberRange)validator;
        try {
            minValue = d = (Double)numberRange.minValue();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Double maxValue = d = (Double)numberRange.maxValue();
        this.slider = new LazySlider(0, 0, 100, 20, this.label, (Double)property.get(), minValue, maxValue, stepSize, arg_0 -> ((DoubleProperty)property).set(arg_0));
        this.slider.setTooltip(TabOptionSliderItem.createTooltipWithWidth(TabOptionSliderItem.createTooltipMessage(property), 250));
        this.slider.setTooltipDelay(Duration.ofMillis(500L));
        this.slider.valueOnly();
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return ImmutableList.of((Object)((Object)this.slider));
    }

    @Override
    public List<GuiEventListener> elements() {
        return Collections.emptyList();
    }

    @Override
    public void render(GuiGraphics graphics, int slotIndex, int top, int left, int listWidth, int slotHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
        super.render(graphics, slotIndex, top, left, listWidth, slotHeight, mouseX, mouseY, hovered, partialTick);
        this.slider.active = this.isOptionActive();
        this.slider.setX(left + listWidth - this.slider.getWidth() - 20);
        this.slider.setY(top);
        this.slider.render(graphics, mouseX, mouseY, partialTick);
        Controller controller = Controllable.getController();
        if (this.slider.active && controller != null && controller.isBeingUsed() && ScreenHelper.isMouseWithin(left, top, listWidth, slotHeight, mouseX, mouseY)) {
            ClientHelper.drawButton(graphics, left + listWidth - this.slider.getWidth() - 20 - 17, top + (slotHeight - 11) / 2, ButtonBindings.NEXT_CREATIVE_TAB.getButton());
            ClientHelper.drawButton(graphics, left + listWidth - 16, top + (slotHeight - 11) / 2, ButtonBindings.PREVIOUS_CREATIVE_TAB.getButton());
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastChange > 100L) {
                boolean changing = false;
                if (ButtonBindings.NEXT_CREATIVE_TAB.isButtonDown()) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ANVIL_STEP, (float)0.7f, (float)0.25f));
                    this.slider.stepBackward();
                    this.lastChange = currentTime;
                    this.save = true;
                    changing = true;
                } else if (ButtonBindings.PREVIOUS_CREATIVE_TAB.isButtonDown()) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ANVIL_STEP, (float)0.75f, (float)0.25f));
                    this.slider.stepForward();
                    this.lastChange = currentTime;
                    this.save = true;
                    changing = true;
                }
                if (!changing && this.save) {
                    this.slider.triggerChangeCallback();
                    this.save = false;
                }
            }
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.slider.mouseReleased(mouseX, mouseY, button);
    }
}

