/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.gui.components.TabOptionBaseItem;
import com.mrcrayfish.controllable.client.gui.navigation.Navigatable;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.framework.api.config.BoolProperty;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TabOptionToggleItem
extends TabOptionBaseItem
implements Navigatable {
    private final AbstractWidget toggle;
    private Consumer<Boolean> changeCallback;
    private final Supplier<Boolean> getter;

    public TabOptionToggleItem(BoolProperty property) {
        this((Component)Component.translatable((String)property.getTranslationKey()), TabOptionToggleItem.createTooltipWithWidth(TabOptionToggleItem.createTooltipMessage(property), 250), () -> ((BoolProperty)property).get(), arg_0 -> ((BoolProperty)property).set(arg_0));
    }

    public TabOptionToggleItem(OptionInstance<Boolean> option) {
        this(ClientHelper.getOptionName(option), ClientHelper.getOptionTooltip(option), () -> option.get(), value -> {
            option.set(value);
            Minecraft.getInstance().options.save();
        });
    }

    public TabOptionToggleItem(Component label, Tooltip tooltip, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        super(label);
        this.getter = getter;
        this.toggle = CycleButton.onOffBuilder((boolean)getter.get()).withTooltip(value -> tooltip).withInitialValue((Object)getter.get()).displayOnlyValue().create(0, 0, 100, 20, CommonComponents.EMPTY, (button, value) -> {
            setter.accept((Boolean)value);
            if (this.changeCallback != null) {
                this.changeCallback.accept((Boolean)value);
            }
        });
        this.toggle.setTooltipDelay(Duration.ofMillis(500L));
    }

    public TabOptionToggleItem setChangeCallback(@Nullable Consumer<Boolean> changeCallback) {
        this.changeCallback = changeCallback;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.getter.get();
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return ImmutableList.of((Object)this.toggle);
    }

    @Override
    public List<GuiEventListener> elements() {
        return Collections.emptyList();
    }

    @Override
    public void render(GuiGraphics graphics, int slotIndex, int top, int left, int listWidth, int slotHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
        super.render(graphics, slotIndex, top, left, listWidth, slotHeight, mouseX, mouseY, hovered, partialTick);
        this.toggle.active = this.isOptionActive();
        this.toggle.setX(left + listWidth - this.toggle.getWidth() - 20);
        this.toggle.setY(top);
        this.toggle.render(graphics, mouseX, mouseY, partialTick);
        Controller controller = Controllable.getController();
        if (this.toggle.active && controller != null && controller.isBeingUsed() && ScreenHelper.isMouseWithin(left, top, listWidth, slotHeight, mouseX, mouseY)) {
            ClientHelper.drawButton(graphics, left + listWidth - 16, top + (slotHeight - 11) / 2, 0);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Controller controller = Controllable.getController();
        if (controller == null || !controller.isBeingUsed()) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (button != 0) {
            return false;
        }
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (!this.toggle.active || !this.toggle.visible) {
            return false;
        }
        this.toggle.playDownSound(Minecraft.getInstance().getSoundManager());
        this.toggle.onClick(mouseX, mouseY);
        return true;
    }
}

