/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.client.gui.navigation.Navigatable;
import com.mrcrayfish.controllable.client.gui.navigation.SkipItem;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TabSelectionList<E extends ContainerObjectSelectionList.Entry<E>>
extends ContainerObjectSelectionList<E>
implements LayoutElement {
    protected Component headerText;
    protected Component footerText;

    public TabSelectionList(Minecraft mc, int itemHeight) {
        super(mc, 0, 0, 0, itemHeight);
    }

    public TabSelectionList<E> setHeaderText(Component headerText) {
        this.headerText = headerText;
        return this;
    }

    public TabSelectionList<E> setFooterText(Component footerText) {
        this.footerText = footerText;
        return this;
    }

    public int getRowWidth() {
        return 290;
    }

    protected int getScrollbarPosition() {
        return this.getRowLeft() + this.getRowWidth() + 4;
    }

    public int addEntry(E entry) {
        return super.addEntry(entry);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void updateDimensions(ScreenRectangle rectangle) {
        boolean header = this.headerText != null;
        boolean footer = this.footerText != null;
        this.width = rectangle.width();
        this.height = rectangle.height() - 15 + (header ? -10 : 0) + (footer ? -20 : 0);
        this.setX(rectangle.left());
        this.setY(rectangle.top() + 15 + (header ? 10 : 0));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        if (this.headerText != null) {
            graphics.drawCenteredString(this.minecraft.font, this.headerText, this.getX() + this.width / 2, this.getY() - 15, 0xFFFFFF);
        }
        if (this.footerText != null) {
            Font font = this.minecraft.font;
            int footerWidth = font.width((FormattedText)this.footerText);
            ScreenHelper.drawRoundedBox(graphics, this.getX() + (this.width - footerWidth) / 2, this.getBottom() + 6, footerWidth, 14, 0x55000000);
            graphics.drawCenteredString(font, this.footerText, this.getX() + this.width / 2, this.getBottom() + 9, 0xFFFFFF);
        }
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
    }

    protected boolean isValidMouseClick(int button) {
        return super.isValidMouseClick(button) || button == 1;
    }

    public static class ButtonItem
    extends BaseItem
    implements Navigatable {
        private final Button button;

        public ButtonItem(Component label, Button.OnPress onPress) {
            super(label);
            this.button = Button.builder((Component)label, (Button.OnPress)onPress).build();
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.button.setWidth(width / 2);
            this.button.setX(left + width / 4);
            this.button.setY(top);
            this.button.render(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.button);
        }

        @Override
        public List<GuiEventListener> elements() {
            return Collections.emptyList();
        }
    }

    public class TitleItem
    extends BaseItem
    implements SkipItem {
        public TitleItem(Component title) {
            super(title);
        }

        public TitleItem(String title) {
            super((Component)Component.literal((String)title).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.YELLOW));
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            Font font = Objects.requireNonNull(((TabSelectionList)TabSelectionList.this).minecraft).font;
            int labelWidth = font.width((FormattedText)this.label) + 2;
            ScreenHelper.drawRoundedBox(graphics, left + width / 2 - labelWidth / 2, top + 2, labelWidth, 14, -2013265920);
            graphics.drawCenteredString(font, this.label, left + width / 2, top + 5, 0xFFFFFF);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }
    }

    public static abstract class BaseItem
    extends Item<BaseItem> {
        public BaseItem(Component label) {
            super(label);
        }

        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
        }
    }

    public static abstract class Item<T extends ContainerObjectSelectionList.Entry<T>>
    extends ContainerObjectSelectionList.Entry<T> {
        protected Component label;

        public Item(Component label) {
            this.label = label;
        }

        public Component getLabel() {
            return this.label;
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput output) {
                    output.add(NarratedElementType.TITLE, label);
                }
            });
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }
    }
}

