/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.navigation;

import com.mrcrayfish.controllable.client.gui.navigation.HideCursor;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.SkipItem;
import com.mrcrayfish.controllable.platform.ClientServices;
import java.util.List;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class ListEntryNavigationPoint
extends NavigationPoint {
    private final AbstractSelectionList<?> list;
    private final GuiEventListener listEntry;
    private final int index;
    private final int itemHeight;
    private final int dir;
    private int itemY;
    private boolean hideCursor;

    public ListEntryNavigationPoint(AbstractSelectionList<?> list, GuiEventListener listEntry, int index, int dir) {
        super(0.0, 0.0, NavigationPoint.Type.BASIC);
        this.list = list;
        this.listEntry = listEntry;
        this.index = index;
        this.itemHeight = ClientServices.CLIENT.getListItemHeight(this.list);
        this.dir = dir;
        this.itemY = ClientServices.CLIENT.getAbstractListRowTop(this.list, index) + this.itemHeight / 2 - 2;
    }

    @Override
    public double distanceTo(double x, double y) {
        return Math.sqrt(Math.pow(this.getX() - x, 2.0) + Math.pow(this.getY() - y, 2.0));
    }

    @Override
    public double getX() {
        return this.list.getRowLeft() + this.list.getRowWidth() / 2;
    }

    @Override
    public double getY() {
        return this.itemY;
    }

    @Override
    public void onNavigate() {
        double scroll;
        int skipIndex;
        int index = this.index;
        GuiEventListener entry = this.listEntry;
        List children = this.list.children();
        if (entry instanceof SkipItem && (skipIndex = index + this.dir) >= 0 && skipIndex < children.size()) {
            index = skipIndex;
            entry = (GuiEventListener)children.get(skipIndex);
        }
        if (index + this.dir == 0 && !children.isEmpty() && children.getFirst() instanceof SkipItem) {
            entry = (GuiEventListener)children.getFirst();
        }
        this.hideCursor = entry instanceof HideCursor;
        int rowTop = ClientServices.CLIENT.getAbstractListRowTop(this.list, index);
        int rowBottom = ClientServices.CLIENT.getAbstractListRowBottom(this.list, index);
        int listTop = ClientServices.CLIENT.getAbstractListTop(this.list);
        int listBottom = ClientServices.CLIENT.getAbstractListBottom(this.list);
        if (rowTop < listTop + this.itemHeight / 2) {
            scroll = this.list.children().indexOf(entry) * this.itemHeight - this.itemHeight / 2;
            this.list.setScrollAmount(scroll);
        }
        if (rowBottom > listBottom - this.itemHeight / 2) {
            scroll = this.list.children().indexOf(entry) * this.itemHeight + this.itemHeight - (listBottom - listTop) + 4 + this.itemHeight / 2;
            this.list.setScrollAmount(scroll);
        }
        this.itemY = ClientServices.CLIENT.getAbstractListRowTop(this.list, index) + this.itemHeight / 2 - 2;
    }

    @Override
    public boolean shouldHide() {
        return this.hideCursor;
    }
}

