/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.Icons;
import com.mrcrayfish.controllable.client.gui.screens.ListMenuScreen;
import com.mrcrayfish.controllable.client.gui.screens.SelectKeyBindingScreen;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class ButtonBindingListMenuScreen
extends ListMenuScreen {
    protected Map<String, List<ButtonBinding>> categories = new LinkedHashMap<String, List<ButtonBinding>>();

    protected ButtonBindingListMenuScreen(Screen parent, Component title, int itemHeight) {
        super(parent, title, itemHeight);
        this.categories.put("key.categories.controllable_custom", new ArrayList());
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
    }

    @Override
    protected List<ListMenuScreen.Item> constructEntries() {
        return this.createItems(false);
    }

    public List<ListMenuScreen.Item> createItems(boolean showUnbound) {
        ArrayList<ListMenuScreen.Item> items = new ArrayList<ListMenuScreen.Item>();
        this.categories.forEach((category, list) -> list.clear());
        Controllable.getBindingRegistry().getBindings().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
            if (showUnbound && !binding.isUnbound()) {
                return;
            }
            List list = this.categories.computeIfAbsent(binding.getCategory(), category -> new ArrayList());
            list.add(binding);
        });
        this.categories.forEach((category, list) -> {
            boolean isCustom = category.equals("key.categories.controllable_custom");
            if (!list.isEmpty() || isCustom) {
                Collections.sort(list);
                items.add(new ListMenuScreen.TitleItem((ListMenuScreen)this, (Component)Component.translatable((String)category).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
                list.forEach(binding -> items.add(this.createItemFromBinding((ButtonBinding)binding)));
                if (isCustom) {
                    MutableComponent addKeybind = ClientHelper.join(Icons.KEY_CAP, (Component)Component.translatable((String)"controllable.gui.add_key_bind"));
                    items.add(new OneWidgetItem(this, (AbstractWidget)Button.builder((Component)addKeybind, btn -> this.minecraft.setScreen((Screen)new SelectKeyBindingScreen(this, this::rebuildItems))).build()));
                }
            }
        });
        return items;
    }

    protected abstract ListMenuScreen.Item createItemFromBinding(ButtonBinding var1);

    public class OneWidgetItem
    extends ListMenuScreen.Item {
        private final AbstractWidget widget;

        public OneWidgetItem(ButtonBindingListMenuScreen this$0, AbstractWidget widget) {
            super((ListMenuScreen)this$0, CommonComponents.EMPTY);
            this.widget = widget;
        }

        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.widget.setWidth((int)((double)width * 0.5));
            this.widget.setX(left + (width - this.widget.getWidth()) / 2);
            this.widget.setY(top);
            this.widget.render(graphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.widget);
        }
    }
}

