/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class ConfirmationScreen
extends Screen {
    private static final ResourceLocation MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/menu_list_background.png");
    private static final ResourceLocation IN_GAME_MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/inworld_menu_list_background.png");
    private static final int FADE_LENGTH = 4;
    private static final int BRIGHTNESS = 32;
    private static final int MESSAGE_PADDING = 10;
    private final Screen parent;
    private final Component message;
    private final Function<Boolean, Boolean> handler;
    private Component positiveText = CommonComponents.GUI_YES;
    private Component negativeText = CommonComponents.GUI_NO;
    private int startY;
    private int endY;
    private Icon icon = Icon.WARNING;

    public ConfirmationScreen(Screen parent, Component message, Function<Boolean, Boolean> handler) {
        super(message);
        this.parent = parent;
        this.message = message;
        this.handler = handler;
    }

    protected void init() {
        List lines = this.font.split((FormattedText)this.message, 300);
        int n = this.height / 2 - 10;
        int n2 = lines.size();
        Objects.requireNonNull(this.font);
        this.startY = n - n2 * (9 + 2) / 2 - 10 - 1;
        int n3 = lines.size();
        Objects.requireNonNull(this.font);
        this.endY = this.startY + n3 * (9 + 2) + 20;
        int offset = this.negativeText != null ? 105 : 50;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.positiveText, button -> {
            if (this.handler.apply(true).booleanValue()) {
                this.minecraft.setScreen(this.parent);
            }
        }).pos(this.width / 2 - offset, this.endY + 10).size(100, 20).build());
        if (this.negativeText != null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.negativeText, button -> {
                if (this.handler.apply(false).booleanValue()) {
                    this.minecraft.setScreen(this.parent);
                }
            }).pos(this.width / 2 + 5, this.endY + 10).size(100, 20).build());
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        List lines = this.font.split((FormattedText)this.message, 300);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(ControllerLayoutScreen.TEXTURE, this.width / 2 - 10, this.startY - 30, 20, 20, (float)(this.icon.ordinal() * 10), 21.0f, 10, 10, 256, 256);
        this.drawListBackground(graphics, 0, this.width, this.startY, this.endY);
        for (int i = 0; i < lines.size(); ++i) {
            int lineWidth = this.font.width((FormattedCharSequence)lines.get(i));
            FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
            int n = this.width / 2 - lineWidth / 2;
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, formattedCharSequence, n, this.startY + 10 + i * (9 + 2) + 1, 0xFFFFFF);
        }
    }

    public void setPositiveText(Component positiveText) {
        this.positiveText = positiveText;
    }

    public void setNegativeText(@Nullable Component negativeText) {
        this.negativeText = negativeText;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void drawListBackground(GuiGraphics graphics, int startX, int endX, int startY, int endY) {
        boolean inGame = Minecraft.getInstance().level != null;
        RenderSystem.enableBlend();
        ResourceLocation backgroundTexture = !inGame ? MENU_LIST_BACKGROUND : IN_GAME_MENU_LIST_BACKGROUND;
        ResourceLocation headerTexture = !inGame ? Screen.HEADER_SEPARATOR : Screen.INWORLD_HEADER_SEPARATOR;
        ResourceLocation footerTexture = !inGame ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR;
        graphics.blit(backgroundTexture, startX, startY, (float)endX, (float)endY, endX - startX, endY - startY, 32, 32);
        graphics.blit(headerTexture, startX, startY - 2, 0.0f, 0.0f, endX - startX, 2, 32, 2);
        graphics.blit(footerTexture, startX, endY, 0.0f, 0.0f, endX - startX, 2, 32, 2);
        RenderSystem.disableBlend();
    }

    public static enum Icon {
        WARNING,
        INFO;

    }
}

