/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.gui.ControllerAxis;
import com.mrcrayfish.controllable.client.gui.ControllerButton;
import com.mrcrayfish.controllable.client.gui.screens.ThumbstickSettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import com.mrcrayfish.controllable.client.input.ButtonStates;
import com.mrcrayfish.controllable.client.input.Buttons;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;

public class ControllerLayoutScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Utils.resource("textures/gui/controller.png");
    private final List<ControllerButton> controllerButtons = new ArrayList<ControllerButton>();
    private int configureButton = -1;
    private boolean validLayout;
    private final Screen parentScreen;
    private final LayoutButtonStates states = new LayoutButtonStates();
    private Button doneButton;
    private Button resetButton;
    private Button thumbstickButton;

    protected ControllerLayoutScreen(Screen parentScreen) {
        super((Component)Component.translatable((String)"controllable.gui.title.layout"));
        this.parentScreen = parentScreen;
    }

    protected void init() {
        this.controllerButtons.clear();
        this.controllerButtons.add(new ControllerButton(this, 0, 29, 9, 7, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 1, 32, 6, 13, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 2, 26, 6, 16, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 3, 29, 3, 10, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 9, 5, -2, 25, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 10, 26, -2, 32, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 11, -10, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 12, 41, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 14, 6, 9, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 16, 9, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 15, 3, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 13, 6, 3, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 4, 14, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 6, 21, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 5, 17, 8, 46, 0, 4, 4, 5));
        this.controllerButtons.add(new ControllerAxis(this, 7, 9, 12, 0, 0, 7, 7, 5));
        this.controllerButtons.add(new ControllerAxis(this, 8, 22, 12, 0, 0, 7, 7, 5));
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"controllable.gui.save"), button -> Objects.requireNonNull(this.minecraft).setScreen(this.parentScreen)).pos(this.width / 2 - 154, this.height - 32).size(100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> Objects.requireNonNull(this.minecraft).setScreen(this.parentScreen)).pos(this.width / 2 + 54, this.height - 32).size(100, 20).build());
        int width = 190;
        int x = this.width / 2 - width / 2;
        int y = this.height / 2 - 50 - 35;
        this.thumbstickButton = (Button)this.addRenderableWidget((GuiEventListener)new ImageButton(x + width / 2 - 10, y + 90, 20, TEXTURE, 92, 0, 16, 16, button -> Objects.requireNonNull(this.minecraft).setScreen((Screen)new ThumbstickSettingsScreen(this))));
    }

    public void tick() {
        this.doneButton.setMessage((Component)Component.translatable((String)"controllable.gui.save").withStyle(this.validLayout ? ChatFormatting.WHITE : ChatFormatting.RED));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ArrayList<Object> components;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int width = 190;
        int height = 120;
        int x = this.width / 2 - width / 2;
        int y = this.height / 2 - 50 - 35;
        graphics.blit(TEXTURE, x, y, width, height, 50.0f, 0.0f, 38, 24, 256, 256);
        this.controllerButtons.forEach(controllerButton -> controllerButton.draw(graphics, x, y, mouseX, mouseY, this.configureButton == controllerButton.getButton()));
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        this.drawMultiLineCenteredString(graphics, this.font, (Component)Component.translatable((String)"controllable.gui.layout.info").withStyle(ChatFormatting.GRAY), x + width / 2, y + 135, width + 190, -1);
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.configureButton != -1) {
            RenderSystem.disableDepthTest();
            graphics.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
            graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"controllable.gui.layout.press_button"), this.width / 2, this.height / 2, -1);
            RenderSystem.enableDepthTest();
            return;
        }
        ControllerButton button = this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null);
        if (button != null) {
            components = new ArrayList<Object>();
            components.add(Component.translatable((String)"controllable.gui.layout.button", (Object[])new Object[]{Component.translatable((String)Buttons.NAMES[button.getButton()]).withStyle(ChatFormatting.BLUE)}));
            components.add(Component.translatable((String)"controllable.gui.layout.remap").withStyle(ChatFormatting.GRAY));
            graphics.renderComponentTooltip(this.font, components, mouseX, mouseY);
        }
        if (!this.validLayout && this.doneButton.isHoveredOrFocused()) {
            components = new ArrayList();
            components.add(Component.translatable((String)"controllable.gui.layout.warning").withStyle(ChatFormatting.RED).getVisualOrderText());
            components.addAll(this.font.split((FormattedText)Component.translatable((String)"controllable.gui.layout.invalid_layout").withStyle(ChatFormatting.GRAY), 180));
            graphics.renderTooltip(this.font, components, mouseX, mouseY - 50);
        }
        if (this.thumbstickButton.isHoveredOrFocused()) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"controllable.gui.layout.thumbsticks"), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        ControllerButton button;
        if (mouseButton == 0 && this.configureButton == -1 && (button = (ControllerButton)this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null)) != null) {
            this.configureButton = button.getButton();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int key, int scanCode, int mods) {
        if (key == 256 && this.configureButton != -1) {
            this.configureButton = -1;
            return true;
        }
        return super.keyPressed(key, scanCode, mods);
    }

    public void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (state) {
            if (!this.states.getState(index)) {
                this.states.setState(index, true);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_ON, (float)1.0f));
            }
        } else if (this.states.getState(index)) {
            this.states.setState(index, false);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_BUTTON_CLICK_ON, (float)0.9f));
        }
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    private void drawMultiLineCenteredString(GuiGraphics graphics, Font font, Component component, int x, int y, int width, int color) {
        for (FormattedCharSequence s : font.split((FormattedText)component, width)) {
            graphics.drawCenteredString(font, s, x - font.width(s) / 2, y, color);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public static class LayoutButtonStates
    extends ButtonStates {
        @Override
        public void setState(int index, boolean state) {
            super.setState(index, state);
        }
    }
}

