/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.gui.ISearchable;
import com.mrcrayfish.controllable.client.gui.Icons;
import com.mrcrayfish.controllable.client.gui.RadialMenuAction;
import com.mrcrayfish.controllable.client.gui.screens.ButtonBindingListMenuScreen;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.screens.ListMenuScreen;
import com.mrcrayfish.controllable.client.gui.screens.RadialMenuConfigureScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class RadialMenuAddBindingsScreen
extends ButtonBindingListMenuScreen {
    public RadialMenuAddBindingsScreen(RadialMenuConfigureScreen parentScreen) {
        super(parentScreen, (Component)Component.translatable((String)"controllable.gui.title.select_button_bindings"), 24);
        this.setRowWidth(290);
    }

    public RadialMenuConfigureScreen getRadialConfigureScreen() {
        return (RadialMenuConfigureScreen)this.parent;
    }

    @Override
    protected void setupFooter(LinearLayout footerLayout) {
        super.setupFooter(footerLayout);
        MutableComponent resetLabel = ClientHelper.join(Icons.RESET, (Component)Component.translatable((String)"controllable.gui.restore_defaults"));
        footerLayout.addChild((LayoutElement)ScreenHelper.button(this.width / 2 - 155, this.height - 29, 150, 20, (Component)resetLabel, button -> Objects.requireNonNull(this.minecraft).setScreen((Screen)new ConfirmationScreen(this, (Component)Component.translatable((String)"controllable.gui.reset_selected_bindings"), result -> {
            if (result.booleanValue()) {
                RadialMenuConfigureScreen screen = this.getRadialConfigureScreen();
                screen.getActions().clear();
                screen.getActions().addAll(Controllable.getRadialMenu().createDefaultActions());
                this.list.children().forEach(item -> {
                    if (item instanceof ButtonBindingItem) {
                        ButtonBindingItem bindingItem = (ButtonBindingItem)item;
                        bindingItem.updateActiveState();
                    }
                });
            }
            return true;
        }))));
        footerLayout.addChild((LayoutElement)ScreenHelper.button(this.width / 2 + 5, this.height - 29, 150, 20, CommonComponents.GUI_BACK, button -> Objects.requireNonNull(this.minecraft).setScreen(this.parent)));
    }

    @Override
    protected void repositionElements() {
        this.getRadialConfigureScreen().getActions().removeIf(action -> {
            ButtonBinding patt0$temp = action.getBinding();
            if (patt0$temp instanceof KeyAdapterBinding) {
                KeyAdapterBinding adapter = (KeyAdapterBinding)patt0$temp;
                return !Controllable.getBindingRegistry().getKeyAdapters().containsValue(adapter);
            }
            return false;
        });
        super.repositionElements();
    }

    @Override
    protected ListMenuScreen.Item createItemFromBinding(ButtonBinding binding) {
        return new ButtonBindingItem(binding);
    }

    public class ButtonBindingItem
    extends ListMenuScreen.Item
    implements ISearchable {
        private final ButtonBinding binding;
        private final Button bindingButton;
        private boolean active;

        protected ButtonBindingItem(ButtonBinding binding) {
            super((Component)Component.translatable((String)binding.getLabelKey()));
            this.binding = binding;
            List<RadialMenuAction> bindings = RadialMenuAddBindingsScreen.this.getRadialConfigureScreen().getActions();
            this.bindingButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 88, 25, 10, 10, button -> {
                bindings.add(new RadialMenuAction(this.binding, ChatFormatting.YELLOW));
                Objects.requireNonNull(RadialMenuAddBindingsScreen.this.minecraft).setScreen(RadialMenuAddBindingsScreen.this.parent);
                RadialMenuAddBindingsScreen.this.getRadialConfigureScreen().scrollToBottomAndSelectLast();
            });
            this.bindingButton.setTooltipDelay(Duration.ofMillis(400L));
            this.updateActiveState();
        }

        @Override
        public Component getLabel() {
            return this.label;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.bindingButton);
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (index % 2 != 0) {
                graphics.fill(left - 2, top - 2, left + rowWidth + 2, top + rowHeight + 2, 0x55000000);
            }
            Font font = ((RadialMenuAddBindingsScreen)RadialMenuAddBindingsScreen.this).minecraft.font;
            int colour = this.active ? ChatFormatting.WHITE.getColor() : ChatFormatting.DARK_GRAY.getColor();
            graphics.drawString(font, this.label, left + 5, top + 6, colour);
            this.bindingButton.setX(left + rowWidth - 25);
            this.bindingButton.setY(top);
            this.bindingButton.render(graphics, mouseX, mouseY, partialTicks);
            this.bindingButton.active = this.active;
        }

        public void updateActiveState() {
            this.active = RadialMenuAddBindingsScreen.this.getRadialConfigureScreen().getActions().stream().noneMatch(data -> data.getBinding() == this.binding);
            Tooltip addTooltip = this.active ? Tooltip.create((Component)Component.translatable((String)"controllable.gui.add_to_radial_menu")) : Tooltip.create((Component)Component.translatable((String)"controllable.gui.binding_already_added").withStyle(ChatFormatting.RED));
            this.bindingButton.setTooltip(addTooltip);
        }
    }
}

