/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.gui.Icons;
import com.mrcrayfish.controllable.client.gui.RadialItemList;
import com.mrcrayfish.controllable.client.gui.RadialMenuAction;
import com.mrcrayfish.controllable.client.gui.screens.RadialMenuAddBindingsScreen;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class RadialMenuConfigureScreen
extends Screen {
    @Nullable
    private final Screen parent;
    private final List<RadialMenuAction> actions = new ArrayList<RadialMenuAction>();
    protected final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private RadialItemList list;

    public RadialMenuConfigureScreen(@Nullable Screen parent) {
        super((Component)Component.translatable((String)"controllable.gui.title.radial_menu_configure"));
        this.parent = parent;
        this.actions.addAll(Controllable.getRadialMenu().getActions());
    }

    protected void init() {
        LinearLayout headerLayout = (LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical());
        headerLayout.addChild((LayoutElement)new StringWidget(this.title, this.font));
        this.list = new RadialItemList(this.minecraft, this.actions);
        this.layout.addToContents((LayoutElement)this.list);
        LinearLayout footerLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(4));
        MutableComponent saveLabel = ClientHelper.join(Icons.SAVE, (Component)Component.translatable((String)"controllable.gui.save"));
        footerLayout.addChild((LayoutElement)ScreenHelper.button(this.width / 2 - 155, this.height - 29, 100, 20, (Component)saveLabel, buttons -> {
            Controllable.getRadialMenu().setActions(this.actions);
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }));
        MutableComponent addLabel = ClientHelper.join(Icons.ADD, (Component)Component.translatable((String)"controllable.gui.add_binding"));
        footerLayout.addChild((LayoutElement)ScreenHelper.button(this.width / 2 - 50, this.height - 29, 100, 20, (Component)addLabel, buttons -> Objects.requireNonNull(this.minecraft).setScreen((Screen)new RadialMenuAddBindingsScreen(this))));
        footerLayout.addChild((LayoutElement)ScreenHelper.button(this.width / 2 + 55, this.height - 29, 100, 20, CommonComponents.GUI_CANCEL, buttons -> Objects.requireNonNull(this.minecraft).setScreen(this.parent)));
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        this.list.updateEntries();
        this.list.updateSize(this.width, this.layout);
    }

    public List<RadialMenuAction> getActions() {
        return this.actions;
    }

    public void scrollToBottomAndSelectLast() {
        this.list.setScrollAmount(this.list.getMaxScroll());
        this.list.setSelected((AbstractSelectionList.Entry)((RadialItemList.ButtonBindingEntry)((Object)this.list.children().getLast())));
    }
}

