/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.gui.Icons;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.screens.KeyBindingListMenuScreen;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SelectKeyBindingScreen
extends KeyBindingListMenuScreen {
    private static final Component LABEL_NO_KEYBINDS_AVAILABLE = Component.translatable((String)"controllable.gui.no_keybinds_available");
    private final Runnable callback;
    private Button resetButton;

    public SelectKeyBindingScreen(Screen parent, Runnable callback) {
        super(parent, (Component)Component.translatable((String)"controllable.gui.title.select_key_bindings"), 22);
        this.callback = callback;
        this.setSubTitle((Component)Component.translatable((String)"controllable.gui.note").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"controllable.gui.key_bind_note").withStyle(ChatFormatting.GRAY)));
    }

    @Override
    protected void setupFooter(LinearLayout footerLayout) {
        super.setupFooter(footerLayout);
        MutableComponent resetLabel = ClientHelper.join(Icons.RESET, (Component)Component.translatable((String)"controllable.gui.reset"));
        this.resetButton = (Button)footerLayout.addChild((LayoutElement)Button.builder((Component)resetLabel, button -> Objects.requireNonNull(this.minecraft).setScreen((Screen)new ConfirmationScreen(this, (Component)Component.translatable((String)"controllable.gui.reset_keybinds"), result -> {
            if (result.booleanValue()) {
                ArrayList<KeyAdapterBinding> copy = new ArrayList<KeyAdapterBinding>(Controllable.getBindingRegistry().getKeyAdapters().values());
                copy.forEach(binding -> {
                    Controllable.getBindingRegistry().removeKeyAdapter((KeyAdapterBinding)binding);
                    Controllable.getRadialMenu().removeBinding((ButtonBinding)binding);
                });
                this.updateButtons();
                this.rebuildItems();
            }
            return true;
        }))).size(150, 20).build());
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.callback.run();
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }).size(150, 20).build());
        this.updateButtons();
    }

    @Override
    protected void repositionElements() {
        this.updateButtons();
        super.repositionElements();
    }

    @Override
    protected void onChange() {
        this.updateButtons();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.list.children().isEmpty()) {
            graphics.drawCenteredString(this.font, LABEL_NO_KEYBINDS_AVAILABLE, this.list.getX() + this.list.getWidth() / 2, this.list.getY() + this.list.getHeight() / 2 - 4, 0xFFFFFF);
        }
    }

    protected void updateButtons() {
        this.resetButton.active = !Controllable.getBindingRegistry().getKeyAdapters().isEmpty();
    }
}

