/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.Icons;
import com.mrcrayfish.controllable.client.gui.components.ButtonBindingList;
import com.mrcrayfish.controllable.client.gui.components.ControllerList;
import com.mrcrayfish.controllable.client.gui.components.FilteredTabSelectionList;
import com.mrcrayfish.controllable.client.gui.components.TabOptionEnumItem;
import com.mrcrayfish.controllable.client.gui.components.TabOptionSliderItem;
import com.mrcrayfish.controllable.client.gui.components.TabOptionTitleItem;
import com.mrcrayfish.controllable.client.gui.components.TabOptionToggleItem;
import com.mrcrayfish.controllable.client.gui.components.TabSelectionList;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.screens.RadialMenuConfigureScreen;
import com.mrcrayfish.controllable.client.gui.widget.TabListWidget;
import com.mrcrayfish.controllable.client.settings.ActionVisibility;
import com.mrcrayfish.controllable.client.settings.AnalogMovement;
import com.mrcrayfish.controllable.client.settings.ButtonIcons;
import com.mrcrayfish.controllable.client.settings.CursorStyle;
import com.mrcrayfish.controllable.client.settings.SneakMode;
import com.mrcrayfish.controllable.client.settings.SprintMode;
import com.mrcrayfish.controllable.client.settings.Thumbstick;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import com.mrcrayfish.framework.api.config.BoolProperty;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.RecipeBook;
import org.jetbrains.annotations.Nullable;

public class SettingsScreen
extends Screen {
    @Nullable
    private final Screen parent;
    private final TabManager tabManager = new TabManager(x$0 -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
    }, x$0 -> this.removeWidget((GuiEventListener)x$0));
    private final List<Runnable> tickers = new ArrayList<Runnable>();
    private ScreenRectangle tabArea;
    private TabNavigationBar navigationBar;
    private Button doneButton;
    private ButtonBinding selectedBinding;
    private int remainingTime;
    private int initialTab = 0;

    public SettingsScreen(@Nullable Screen parent) {
        super((Component)Component.translatable((String)"controllable.settings"));
        this.parent = parent;
    }

    public SettingsScreen(@Nullable Screen parent, int initialTab) {
        super((Component)Component.translatable((String)"controllable.settings"));
        this.parent = parent;
        this.initialTab = initialTab;
    }

    @Nullable
    public Screen getParent() {
        return this.parent;
    }

    protected void init() {
        this.tickers.clear();
        this.navigationBar = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs(new Tab[]{new ControllerTab(this), new SettingsTab(), new BindingsTab()}).build();
        this.addRenderableWidget((GuiEventListener)this.navigationBar);
        this.navigationBar.selectTab(this.initialTab, false);
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.minecraft.setScreen(this.parent)).pos((this.width - 200) / 2, this.height - 25).width(200).build());
        this.repositionElements();
    }

    protected void repositionElements() {
        if (this.navigationBar != null) {
            this.navigationBar.setWidth(this.width);
            this.navigationBar.arrangeElements();
            ScreenRectangle navBarArea = this.navigationBar.getRectangle();
            this.tabArea = new ScreenRectangle(0, navBarArea.height() - 1, this.width, this.height - navBarArea.height() - 30);
            this.tabManager.setTabArea(this.tabArea);
        }
        if (this.doneButton != null) {
            this.doneButton.setX((this.width - 200) / 2);
            this.doneButton.setY(this.height - 25);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xScroll, double yScroll) {
        if (super.mouseScrolled(mouseX, mouseY, xScroll, yScroll)) {
            return true;
        }
        Tab currentTab = this.tabManager.getCurrentTab();
        if (currentTab == null) {
            return false;
        }
        ArrayList widgets = new ArrayList();
        currentTab.visitChildren(widgets::add);
        return widgets.stream().filter(widget -> widget.isMouseOver(mouseX, mouseY) && widget.mouseScrolled(mouseX, mouseY, xScroll, yScroll)).count() > 0L;
    }

    public void tick() {
        this.tickers.forEach(Runnable::run);
        if (this.isWaitingForButtonInput()) {
            --this.remainingTime;
            if (this.remainingTime <= 0) {
                this.selectedBinding = null;
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean waitingForInput = this.isWaitingForButtonInput();
        super.render(graphics, !waitingForInput ? mouseX : -1, !waitingForInput ? mouseY : -1, partialTick);
        if (waitingForInput) {
            this.renderBlurredBackground(partialTick);
            PoseStack stack = graphics.pose();
            stack.pushPose();
            stack.translate(0.0f, 0.0f, 100.0f);
            graphics.fillGradient(0, 0, this.width, this.height, -535818224, -267382768);
            ScreenHelper.drawRoundedBox(graphics, (int)((double)this.width * 0.125), this.height / 4, (int)((double)this.width * 0.75), this.height / 2, -1728053248);
            MutableComponent pressButtonLabel = Component.translatable((String)"controllable.gui.waiting_for_input").withStyle(ChatFormatting.YELLOW);
            graphics.drawCenteredString(this.font, (Component)pressButtonLabel, this.width / 2, this.height / 2 - 10, -1);
            MutableComponent time = Component.literal((String)Integer.toString((int)Math.ceil((double)this.remainingTime / 20.0)));
            MutableComponent inputCancelLabel = Component.translatable((String)"controllable.gui.input_cancel", (Object[])new Object[]{time});
            graphics.drawCenteredString(this.font, (Component)inputCancelLabel, this.width / 2, this.height / 2 + 3, -1);
            stack.popPose();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.selectedBinding != null) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int key, int action, int modifiers) {
        if (this.selectedBinding != null) {
            if (key == 256) {
                this.selectedBinding = null;
            }
            return true;
        }
        if (this.navigationBar.keyPressed(key)) {
            return true;
        }
        return super.keyPressed(key, action, modifiers);
    }

    public void setSelectedBinding(ButtonBinding binding) {
        if (this.tabManager.getCurrentTab() instanceof BindingsTab) {
            this.selectedBinding = binding;
            this.remainingTime = 100;
        }
    }

    public boolean isWaitingForButtonInput() {
        if (this.selectedBinding != null && !(this.tabManager.getCurrentTab() instanceof BindingsTab)) {
            this.selectedBinding = null;
        }
        return this.selectedBinding != null;
    }

    public boolean processButton(int index) {
        if (this.selectedBinding != null) {
            ButtonBinding.setButton(this.selectedBinding, index);
            this.selectedBinding = null;
            BindingRegistry registry = Controllable.getBindingRegistry();
            registry.rebuildCache();
            registry.save();
            return true;
        }
        return false;
    }

    public class ControllerTab
    extends GridLayoutTab {
        private static final Component TITLE = Component.empty().append((Component)ClientHelper.getIconComponent(Icons.CONTROLLER)).append(" ").append((Component)Component.translatable((String)"controllable.settings.tab.controller.title"));

        public ControllerTab(SettingsScreen screen) {
            super(TITLE);
            GridLayout.RowHelper rootHelper = this.layout.rowSpacing(8).createRowHelper(1);
            ControllerList list = new ControllerList(SettingsScreen.this, SettingsScreen.this.minecraft, 24);
            rootHelper.addChild((LayoutElement)new TabListWidget(() -> SettingsScreen.this.tabArea, list));
            screen.tickers.add(list::tick);
        }
    }

    public class SettingsTab
    extends GridLayoutTab {
        private static final Component TITLE = Component.empty().append((Component)ClientHelper.getIconComponent(Icons.SETTINGS)).append(" ").append((Component)Component.translatable((String)"controllable.settings.tab.settings.title"));

        public SettingsTab() {
            super(TITLE);
            Minecraft mc = Objects.requireNonNull(SettingsScreen.this.minecraft);
            GridLayout.RowHelper rootHelper = this.layout.rowSpacing(8).createRowHelper(1);
            FilteredTabSelectionList<TabSelectionList.BaseItem> optionsList = new FilteredTabSelectionList<TabSelectionList.BaseItem>(SettingsScreen.this.minecraft, 24);
            MutableComponent updateMappings = ClientHelper.join(Icons.WORLD, (Component)Component.translatable((String)"controllable.gui.update_mappings"));
            MutableComponent restoreDefaults = ClientHelper.join(Icons.RESET, (Component)Component.translatable((String)"controllable.gui.restore_defaults"));
            optionsList.addEntry(new ButtonBindingList.TwoWidgetItem((AbstractWidget)Button.builder((Component)updateMappings, btn -> {
                ConfirmationScreen updateConfirmation = new ConfirmationScreen(SettingsScreen.this, (Component)Component.translatable((String)"controllable.gui.update_mapping_message", (Object[])new Object[]{Component.literal((String)"https://raw.githubusercontent.com/gabomdq/SDL_GameControllerDB/master/gamecontrollerdb.txt").withStyle(ChatFormatting.YELLOW)}), result -> {
                    if (result.booleanValue()) {
                        Controllable.getControllerManager().downloadMappings(SettingsScreen.this);
                        return false;
                    }
                    return true;
                });
                updateConfirmation.setPositiveText((Component)ClientHelper.join(Icons.DOWNLOAD, (Component)Component.translatable((String)"controllable.gui.download")));
                updateConfirmation.setNegativeText(CommonComponents.GUI_CANCEL);
                updateConfirmation.setIcon(ConfirmationScreen.Icon.INFO);
                mc.setScreen((Screen)updateConfirmation);
            }).build(), (AbstractWidget)Button.builder((Component)restoreDefaults, btn -> mc.setScreen((Screen)new ConfirmationScreen(SettingsScreen.this, (Component)Component.translatable((String)"controllable.gui.restore_defaults"), result -> {
                FrameworkConfigManager.FrameworkConfigImpl config;
                if (result.booleanValue() && (config = FrameworkConfigManager.getInstance().getConfig(Config.CLIENT_CONFIG_ID)) != null) {
                    config.getAllProperties().forEach(AbstractProperty::restoreDefault);
                    mc.setScreen((Screen)new SettingsScreen(SettingsScreen.this.parent, 1));
                    return false;
                }
                return true;
            }))).build()));
            MutableComponent radialMenuLabel = ClientHelper.join(Icons.SETTINGS, (Component)Component.translatable((String)"controllable.gui.title.radial_menu_configure"));
            optionsList.addEntry(new ButtonBindingList.OneWidgetItem((AbstractWidget)Button.builder((Component)radialMenuLabel, button -> {
                Controllable.getRadialMenu().load();
                Minecraft.getInstance().setScreen((Screen)new RadialMenuConfigureScreen(SettingsScreen.this));
            }).build()));
            optionsList.addEntry(new TabOptionTitleItem((Component)Component.translatable((String)"controllable.gui.title.gameplay").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            optionsList.addEntry(new TabOptionEnumItem<SneakMode>((Component)Component.translatable((String)"controllable.gui.sneak_mode"), (Component)Component.translatable((String)"controllable.gui.sneak_mode.desc"), () -> (Boolean)mc.options.toggleCrouch().get() != false ? SneakMode.TOGGLE : SneakMode.HOLD, sneakMode -> {
                mc.options.toggleCrouch().set((Object)(sneakMode == SneakMode.TOGGLE ? 1 : 0));
                mc.options.save();
            }));
            optionsList.addEntry(new TabOptionEnumItem<SprintMode>((Component)Component.translatable((String)"controllable.gui.sprint_mode"), (Component)Component.translatable((String)"controllable.gui.sprint_mode.desc"), () -> (Boolean)mc.options.toggleSprint().get() != false ? SprintMode.TOGGLE : SprintMode.ONCE, sprintMode -> {
                mc.options.toggleSprint().set((Object)(sprintMode == SprintMode.TOGGLE ? 1 : 0));
                mc.options.save();
            }));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.quickCraft).setChangeCallback(value -> {
                if (mc.player != null && mc.level != null) {
                    ClientRecipeBook book = mc.player.getRecipeBook();
                    List holders = book.getCollections().stream().flatMap(c -> c.getRecipes().stream()).toList();
                    RegistryAccess access = mc.level.registryAccess();
                    book.setupCollections(holders, access);
                    book.getCollections().forEach(c -> c.updateKnownRecipes((RecipeBook)book));
                }
            }));
            optionsList.addEntry(new TabOptionEnumItem<Thumbstick>(Config.CLIENT.options.radialThumbstick));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.options.spyglassSensitivity, 0.05));
            optionsList.addEntry(new TabOptionTitleItem((Component)Component.translatable((String)"controllable.gui.title.camera").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.options.rotationSpeed, 1.0));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.options.pitchSensitivity, 0.01));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.options.yawSensitivity, 0.01));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.invertLook));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.invertRotation));
            optionsList.addEntry(new TabOptionTitleItem((Component)Component.translatable((String)"controllable.gui.title.display").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            optionsList.addEntry(new TabOptionEnumItem<ButtonIcons>(Config.CLIENT.options.controllerIcons));
            optionsList.addEntry(new TabOptionEnumItem<ActionVisibility>(Config.CLIENT.options.showButtonHints));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.drawHintBackground));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.consoleHotbar));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.paperDoll));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.overlayTimeout));
            optionsList.addEntry(new TabOptionTitleItem((Component)Component.translatable((String)"controllable.gui.title.controller").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            optionsList.addEntry(new TabOptionEnumItem<AnalogMovement>(Config.CLIENT.options.analogMovement));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.autoSelect));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.backgroundInput));
            TabOptionSliderItem deadzoneOption = new TabOptionSliderItem(Config.CLIENT.options.thumbstickDeadZone, 0.01);
            deadzoneOption.setVisibilityCondition(() -> (Boolean)Config.CLIENT.options.advanced.advancedMode.get() == false);
            optionsList.addEntry(deadzoneOption);
            TabOptionSliderItem leftDeadzoneOption = new TabOptionSliderItem(Config.CLIENT.options.advanced.leftThumbstickDeadZone, 0.01);
            leftDeadzoneOption.setVisibilityCondition(() -> ((BoolProperty)Config.CLIENT.options.advanced.advancedMode).get());
            optionsList.addEntry(leftDeadzoneOption);
            TabOptionSliderItem rightDeadzoneOption = new TabOptionSliderItem(Config.CLIENT.options.advanced.rightThumbstickDeadZone, 0.01);
            rightDeadzoneOption.setVisibilityCondition(() -> ((BoolProperty)Config.CLIENT.options.advanced.advancedMode).get());
            optionsList.addEntry(rightDeadzoneOption);
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.options.triggerDeadZone, 0.01));
            TabOptionToggleItem disableVirtualCursor = new TabOptionToggleItem(Config.CLIENT.options.disableVirtualCursor);
            optionsList.addEntry(disableVirtualCursor);
            TabOptionSliderItem cursorSpeed = new TabOptionSliderItem(Config.CLIENT.options.cursorSpeed, 1.0);
            cursorSpeed.setDependentOption(disableVirtualCursor, true);
            optionsList.addEntry(cursorSpeed);
            TabOptionEnumItem<CursorStyle> cursorType = new TabOptionEnumItem<CursorStyle>(Config.CLIENT.options.cursorType);
            cursorType.setDependentOption(disableVirtualCursor, true);
            optionsList.addEntry(cursorType);
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.options.listScrollSpeed, 1.0));
            optionsList.addEntry(new TabOptionSliderItem(Config.CLIENT.options.hoverModifier, 0.05));
            if (!Minecraft.ON_OSX) {
                optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.rumble));
            }
            optionsList.addEntry(new TabOptionTitleItem((Component)Component.translatable((String)"controllable.gui.title.other").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.navigateSound));
            optionsList.addEntry(new TabOptionToggleItem(Config.CLIENT.options.fpsPollingFix));
            TabOptionToggleItem advancedModeOption = new TabOptionToggleItem(Config.CLIENT.options.advanced.advancedMode);
            advancedModeOption.setChangeCallback(aBoolean -> optionsList.rebuildList(true));
            optionsList.addEntry(advancedModeOption);
            rootHelper.addChild((LayoutElement)new TabListWidget(() -> SettingsScreen.this.tabArea, optionsList));
            optionsList.rebuildList(false);
        }
    }

    public class BindingsTab
    extends GridLayoutTab {
        private static final Component TITLE = Component.empty().append((Component)ClientHelper.getIconComponent(Icons.BINDINGS)).append(" ").append((Component)Component.translatable((String)"controllable.settings.tab.bindings.title"));

        public BindingsTab() {
            super(TITLE);
            GridLayout.RowHelper rootHelper = this.layout.rowSpacing(8).createRowHelper(1);
            rootHelper.addChild((LayoutElement)new TabListWidget(() -> SettingsScreen.this.tabArea, new ButtonBindingList(SettingsScreen.this, SettingsScreen.this.minecraft, 24)));
        }
    }
}

