/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.toasts;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ConnectionToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/system");
    private final boolean connected;
    private final Component controllerName;

    public ConnectionToast(boolean connected, String controllerName) {
        this.connected = connected;
        this.controllerName = Component.literal((String)controllerName);
    }

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent toastComponent, long delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blitSprite(BACKGROUND_SPRITE, 0, 0, 160, 32);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(ControllerLayoutScreen.TEXTURE, 8, 8, 20, 43, 20, 16);
        String title = toastComponent.getMinecraft().font.plainSubstrByWidth(this.controllerName.getString(), 120);
        graphics.drawString(toastComponent.getMinecraft().font, title, 35, 7, 0);
        MutableComponent message = this.connected ? Component.translatable((String)"controllable.toast.connected").withStyle(ChatFormatting.DARK_GREEN).withStyle(ChatFormatting.BOLD) : Component.translatable((String)"controllable.toast.disconnected").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD);
        graphics.drawString(toastComponent.getMinecraft().font, (Component)message, 35, 18, 0);
        return delta >= 3000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

