/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import org.apache.commons.lang3.ArrayUtils;

public class ColorButton
extends Button {
    private static final ChatFormatting[] COLORS = new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.DARK_BLUE, ChatFormatting.DARK_GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.DARK_RED, ChatFormatting.DARK_PURPLE, ChatFormatting.GOLD, ChatFormatting.GRAY, ChatFormatting.DARK_GRAY, ChatFormatting.BLUE, ChatFormatting.GREEN, ChatFormatting.AQUA, ChatFormatting.RED, ChatFormatting.LIGHT_PURPLE, ChatFormatting.YELLOW, ChatFormatting.WHITE};
    private int index = 14;

    public ColorButton(int x, int y, Button.OnPress onPress) {
        super(x, y, 20, 20, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
    }

    public void setColor(ChatFormatting color) {
        int index = ArrayUtils.indexOf((Object[])COLORS, (Object)color);
        if (index != -1) {
            this.index = index;
        }
    }

    public ChatFormatting getColor() {
        return COLORS[this.index];
    }

    public void onClick(double mouseX, double mouseY) {
        this.index = (this.index + 1) % COLORS.length;
        super.onClick(mouseX, mouseY);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableDepthTest();
        graphics.fill(this.getX() + 4, this.getY() + 4, this.getX() + 16, this.getY() + 16, -16777216);
        graphics.fill(this.getX() + 5, this.getY() + 5, this.getX() + 15, this.getY() + 15, COLORS[this.index].getColor() + -16777216);
        RenderSystem.enableDepthTest();
    }
}

