/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;

public class ImageButton
extends Button {
    private final ResourceLocation texture;
    private final int imageU;
    private final int imageV;
    private final int imageWidth;
    private final int imageHeight;
    private final int textureWidth;
    private final int textureHeight;

    public ImageButton(int x, int y, int width, ResourceLocation texture, int imageU, int imageV, int imageWidth, int imageHeight, Button.OnPress onPress) {
        this(x, y, width, texture, imageU, imageV, imageWidth, imageHeight, 256, 256, onPress);
    }

    public ImageButton(int x, int y, int width, ResourceLocation texture, int imageU, int imageV, int imageWidth, int imageHeight, int textureWidth, int textureHeight, Button.OnPress onPress) {
        super(x, y, width, 20, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
        this.texture = texture;
        this.imageU = imageU;
        this.imageV = imageV;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.active) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        graphics.blit(this.texture, this.getX() + (this.width - this.imageWidth) / 2, this.getY() + (this.height - this.imageHeight) / 2, (float)this.imageU, (float)this.imageV, this.imageWidth, this.imageHeight, this.textureWidth, this.textureHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

