/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.widget;

import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class LazySlider
extends AbstractSliderButton {
    private static final DecimalFormat FORMATTER = new DecimalFormat("###0.###");
    private final Component label;
    private final double minValue;
    private final double maxValue;
    private final double step;
    private final Consumer<Double> onChange;
    private boolean pressed = false;
    private boolean valueOnly = false;

    public LazySlider(int x, int y, int width, int height, Component label, double initialValue, double minValue, double maxValue, double step, Consumer<Double> onChange) {
        super(x, y, width, height, label, LazySlider.parseValue(initialValue, step, minValue, maxValue));
        this.label = label;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.onChange = onChange;
        this.updateMessage();
    }

    public void valueOnly() {
        this.valueOnly = true;
        this.updateMessage();
    }

    public void onClick(double mouseX, double mouseY) {
        super.onClick(mouseX, mouseY);
        this.pressed = true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button) && this.pressed) {
            this.onChange.accept(this.getValue());
            this.pressed = false;
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double p_93645_, double p_93646_, int p_93647_, double p_93648_, double p_93649_) {
        return this.pressed && super.mouseDragged(p_93645_, p_93646_, p_93647_, p_93648_, p_93649_);
    }

    public double getValue() {
        double scale = 1.0 / this.step;
        double value = this.minValue + (this.maxValue - this.minValue) * this.value;
        return (double)Mth.floor((double)(value * scale)) / scale;
    }

    protected void updateMessage() {
        if (this.valueOnly) {
            this.setMessage((Component)Component.empty().append(FORMATTER.format(this.getValue())));
        } else {
            this.setMessage((Component)Component.empty().append(this.label).append(": ").append(FORMATTER.format(this.getValue())));
        }
    }

    protected void applyValue() {
    }

    private static double parseValue(double value, double step, double minValue, double maxValue) {
        double range = Math.abs(maxValue - minValue);
        value -= minValue;
        return value /= range;
    }

    public void stepForward() {
        if (this.value < 1.0) {
            this.value = Mth.clamp((double)(this.value + this.step / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
            this.updateMessage();
        }
    }

    public void stepBackward() {
        if (this.value > 0.0) {
            this.value = Mth.clamp((double)(this.value - this.step / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
            this.updateMessage();
        }
    }

    public void triggerChangeCallback() {
        this.onChange.accept(this.getValue());
    }
}

