/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.controllable.client.gui.components.TabSelectionList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import org.jetbrains.annotations.Nullable;

public class TabListWidget
extends AbstractWidget
implements ContainerEventHandler {
    private final Supplier<ScreenRectangle> dimensions;
    private final TabSelectionList list;

    public TabListWidget(Supplier<ScreenRectangle> dimensions, TabSelectionList list) {
        super(0, 0, 100, 0, CommonComponents.EMPTY);
        this.dimensions = dimensions;
        this.list = list;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ScreenRectangle dimensions = this.dimensions.get();
        this.setX(dimensions.left());
        this.setY(dimensions.top());
        this.width = dimensions.width();
        this.height = dimensions.height();
        this.list.updateDimensions(dimensions);
        this.list.render(graphics, mouseX, mouseY, partialTick);
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.list.updateNarration(output);
    }

    public List<? extends GuiEventListener> children() {
        return ImmutableList.of((Object)((Object)this.list));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.list.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double $$0, double $$1, int $$2, double $$3, double $$4) {
        return this.list.mouseDragged($$0, $$1, $$2, $$3, $$4);
    }

    public boolean mouseReleased(double $$0, double $$1, int $$2) {
        return this.list.mouseReleased($$0, $$1, $$2);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xScroll, double yScroll) {
        return this.list.mouseScrolled(mouseX, mouseY, xScroll, yScroll);
    }

    public boolean isDragging() {
        return this.list.isDragging();
    }

    public void setDragging(boolean dragging) {
        this.list.setDragging(dragging);
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.list.getFocused();
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        this.list.setFocused(listener);
    }
}

