/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input;

import com.google.common.io.MoreFiles;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Constants;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.screens.PendingScreen;
import com.mrcrayfish.controllable.client.gui.toasts.ConnectionToast;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.DeviceInfo;
import com.mrcrayfish.controllable.client.input.MultiController;
import com.mrcrayfish.controllable.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AdaptiveControllerManager {
    public static final String MAPPINGS_URL = "https://raw.githubusercontent.com/gabomdq/SDL_GameControllerDB/master/gamecontrollerdb.txt";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected Controller activeController;
    protected Map<Number, Pair<Integer, String>> controllers = new HashMap<Number, Pair<Integer, String>>();
    protected List<DeviceInfo> lastDevices = new ArrayList<DeviceInfo>();
    protected boolean ready = false;

    public abstract void init();

    public abstract void dispose();

    public abstract Controller createController(int var1, Number var2);

    @Nullable
    public abstract Controller connectToBestGameController();

    public abstract void updateMappings(InputStream var1) throws IOException;

    protected abstract int getRawControllerCount();

    protected abstract Map<Number, Pair<Integer, String>> createRawControllerMap();

    public void tick() {
        this.updateControllers();
    }

    private void updateControllers() {
        if (this.getRawControllerCount() == this.controllers.size()) {
            return;
        }
        Map<Number, Pair<Integer, String>> oldControllers = this.controllers;
        this.controllers = this.createRawControllerMap();
        oldControllers.keySet().removeIf(this.controllers::containsKey);
        Controller activeController = this.getActiveController();
        if (activeController instanceof MultiController) {
            MultiController multi = (MultiController)activeController;
            for (Controller childController : multi.getControllers()) {
                if (!oldControllers.containsKey(childController.getJid())) continue;
                this.removeActiveController(childController);
            }
        } else if (activeController != null && oldControllers.containsKey(activeController.getJid())) {
            this.sendControllerToast(false, activeController);
            this.setActiveController(null);
            activeController = null;
        }
        if (this.ready && activeController == null && ((Boolean)Config.CLIENT.options.autoSelect.get()).booleanValue()) {
            activeController = this.connectToBestGameController();
            this.sendControllerToast(true, activeController);
        }
    }

    protected void sendControllerToast(boolean connected, @Nullable Controller controller) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && controller != null) {
            mc.getToasts().addToast((Toast)new ConnectionToast(connected, controller.getName()));
        }
    }

    public Map<Number, Pair<Integer, String>> getControllers() {
        return this.controllers;
    }

    @Nullable
    public Controller getActiveController() {
        return this.activeController;
    }

    public final boolean setActiveController(@Nullable Controller controller) {
        if (this.activeController != null) {
            this.activeController.close();
            this.activeController = null;
        }
        if (controller != null && controller.open()) {
            this.activeController = controller;
        }
        return true;
    }

    public final boolean addActiveController(Controller controller) {
        if (!controller.open()) {
            return false;
        }
        if (this.activeController != null) {
            Controller controller2 = this.activeController;
            if (controller2 instanceof MultiController) {
                MultiController activeMultiController = (MultiController)controller2;
                ArrayList<Controller> newControllers = new ArrayList<Controller>(activeMultiController.getControllers());
                newControllers.add(controller);
                this.setActiveController(new MultiController(newControllers));
            } else {
                this.setActiveController(new MultiController(List.of(this.activeController, controller)));
            }
        } else {
            this.setActiveController(controller);
        }
        return true;
    }

    public final boolean removeActiveController(Controller controller) {
        if (this.activeController != null) {
            Controller controller2 = this.activeController;
            if (controller2 instanceof MultiController) {
                MultiController m = (MultiController)controller2;
                ArrayList<Controller> controllers = new ArrayList<Controller>(m.getControllers());
                controllers.remove(controller);
                if (controllers.isEmpty()) {
                    this.setActiveController(null);
                } else if (controllers.size() == 1) {
                    this.setActiveController((Controller)controllers.getFirst());
                } else {
                    this.setActiveController(new MultiController(controllers));
                }
                return true;
            }
            if (this.activeController.getJid().equals(controller.getJid())) {
                this.setActiveController(null);
                return true;
            }
        }
        return false;
    }

    public int getControllerCount() {
        return this.controllers.size();
    }

    public final void completeSetup() {
        block21: {
            this.loadLastDevices();
            try (InputStream is = AdaptiveControllerManager.class.getResourceAsStream("/gamecontrollerdb.txt");){
                if (is != null) {
                    Constants.LOG.info("Applying gamepad mappings from internal database");
                    this.updateMappings(is);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                Path path = Utils.getConfigDirectory().resolve("controllable").resolve("gamecontrollerdb.txt");
                MoreFiles.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
                if (!Files.exists(path, new LinkOption[0])) break block21;
                Constants.LOG.info("Applying gamepad mappings from: {}", (Object)path.toAbsolutePath());
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    this.updateMappings(is);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (((Boolean)Config.CLIENT.options.autoSelect.get()).booleanValue()) {
            this.connectToBestGameController();
        }
        this.ready = true;
    }

    public List<DeviceInfo> getLastDevices() {
        return this.lastDevices;
    }

    public void updateLastDevices() {
        this.lastDevices.clear();
        if (this.activeController != null) {
            Controller controller2 = this.activeController;
            if (controller2 instanceof MultiController) {
                MultiController m = (MultiController)controller2;
                m.getControllers().forEach(controller -> this.lastDevices.add(controller.getInfo()));
            } else {
                this.lastDevices.add(this.activeController.getInfo());
            }
        }
        this.saveLastDevices();
    }

    private void loadLastDevices() {
        try {
            this.lastDevices.clear();
            Path path = Utils.getConfigDirectory().resolve("controllable").resolve("selected_controllers.json");
            MoreFiles.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonObject object = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                JsonElement jsonElement = object.get("selected");
                if (!(jsonElement instanceof JsonArray)) {
                    return;
                }
                JsonArray array = (JsonArray)jsonElement;
                array.forEach(element -> {
                    if (element instanceof JsonObject) {
                        JsonObject child = (JsonObject)element;
                        this.lastDevices.add(DeviceInfo.fromJson((JsonElement)child));
                    }
                });
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to load controller.properties", (Throwable)e);
        }
    }

    private void saveLastDevices() {
        try {
            JsonObject object = new JsonObject();
            object.addProperty("__comment", "Information to restore the selected controllers for next load of the game");
            JsonArray selected = new JsonArray();
            this.lastDevices.forEach(info -> selected.add((JsonElement)info.toJson()));
            object.add("selected", (JsonElement)selected);
            String json = GSON.toJson((JsonElement)object);
            Path path = Utils.getConfigDirectory().resolve("controllable").resolve("selected_controllers.json");
            MoreFiles.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void downloadMappings(@Nullable Screen parentScreen) {
        Constants.LOG.info("Downloading mappings from: {}", (Object)MAPPINGS_URL);
        try {
            Path path = Utils.getConfigDirectory().resolve("controllable").resolve("gamecontrollerdb.txt");
            MoreFiles.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            CompletableFuture.supplyAsync(() -> {
                Minecraft mc = Minecraft.getInstance();
                mc.executeBlocking(() -> mc.setScreen((Screen)new PendingScreen((Component)Component.translatable((String)"controllable.gui.downloading_mappings"))));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                try (BufferedInputStream in = new BufferedInputStream(new URI(MAPPINGS_URL).toURL().openStream());){
                    Boolean bl;
                    block17: {
                        OutputStream fos = Files.newOutputStream(path, new OpenOption[0]);
                        try {
                            int length;
                            byte[] buffer = new byte[1024];
                            while ((length = ((InputStream)in).read(buffer, 0, buffer.length)) != -1) {
                                fos.write(buffer, 0, length);
                            }
                            Constants.LOG.info("Finished downloading mappings");
                            bl = true;
                            if (fos == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        fos.close();
                    }
                    return bl;
                }
                catch (IOException e) {
                    Constants.LOG.error("Failed to download mappings", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                return false;
            }).thenAcceptAsync(success -> {
                if (success.booleanValue()) {
                    Constants.LOG.info("Updating mappings...");
                    Minecraft mc = Minecraft.getInstance();
                    mc.executeBlocking(() -> {
                        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                            this.updateMappings(is);
                            ConfirmationScreen infoScreen = new ConfirmationScreen(parentScreen, (Component)Component.translatable((String)"controllable.gui.mappings_updated"), result -> true);
                            infoScreen.setPositiveText(CommonComponents.GUI_BACK);
                            infoScreen.setNegativeText(null);
                            infoScreen.setIcon(ConfirmationScreen.Icon.INFO);
                            mc.setScreen((Screen)infoScreen);
                        }
                        catch (IOException e) {
                            Constants.LOG.error("Failed to update mappings", (Throwable)e);
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

