/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.input.ButtonStates;
import com.mrcrayfish.controllable.client.input.DeviceInfo;
import com.mrcrayfish.controllable.client.settings.Thumbstick;
import com.mrcrayfish.controllable.client.util.InputHelper;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;

public abstract class Controller {
    protected final ButtonStates states = new ButtonStates();
    protected long lastInputTime;

    public abstract boolean open();

    public abstract void close();

    public abstract Number getJid();

    public abstract boolean isOpen();

    public abstract ButtonStates captureButtonStates();

    public abstract String getName();

    public abstract boolean supportsRumble();

    public final boolean rumble(float lowFrequency, float highFrequency, int timeInMs) {
        return this.isAccessible() && this.internalRumble(lowFrequency, highFrequency, timeInMs);
    }

    protected abstract boolean internalRumble(float var1, float var2, int var3);

    public final float getLTriggerValue() {
        return this.isAccessible() ? InputHelper.applyDeadzone(this.internalGetLTriggerValue(), this.getTriggerDeadzone()) : 0.0f;
    }

    protected abstract float internalGetLTriggerValue();

    public final float getRTriggerValue() {
        return this.isAccessible() ? InputHelper.applyDeadzone(this.internalGetRTriggerValue(), this.getTriggerDeadzone()) : 0.0f;
    }

    protected abstract float internalGetRTriggerValue();

    public final float getLThumbStickXValue() {
        return this.isAccessible() ? InputHelper.applyDeadzone(this.internalGetLThumbStickXValue(), this.getThumbstickDeadzone(Thumbstick.LEFT)) : 0.0f;
    }

    protected abstract float internalGetLThumbStickXValue();

    public final float getLThumbStickYValue() {
        return this.isAccessible() ? InputHelper.applyDeadzone(this.internalGetLThumbStickYValue(), this.getThumbstickDeadzone(Thumbstick.LEFT)) : 0.0f;
    }

    protected abstract float internalGetLThumbStickYValue();

    public final float getRThumbStickXValue() {
        return this.isAccessible() ? InputHelper.applyDeadzone(this.internalGetRThumbStickXValue(), this.getThumbstickDeadzone(Thumbstick.RIGHT)) : 0.0f;
    }

    protected abstract float internalGetRThumbStickXValue();

    public final float getRThumbStickYValue() {
        return this.isAccessible() ? InputHelper.applyDeadzone(this.internalGetRThumbStickYValue(), this.getThumbstickDeadzone(Thumbstick.RIGHT)) : 0.0f;
    }

    protected abstract float internalGetRThumbStickYValue();

    public abstract DeviceInfo getInfo();

    public ButtonStates getTrackedButtonStates() {
        return this.states;
    }

    public boolean isButtonPressed(int button) {
        return this.isAccessible() && this.states.getState(button);
    }

    public final long getLastInputTime() {
        return this.lastInputTime;
    }

    public final void updateInputTime() {
        this.lastInputTime = Util.getMillis();
    }

    public final boolean isBeingUsed() {
        return Util.getMillis() - this.lastInputTime < 4000L;
    }

    public final boolean isUsingVirtualCursor() {
        return this.isBeingUsed() && Controllable.getCursor().getMode().isController() && Controllable.getCursor().isEnabled();
    }

    public final float getPressedValue(int button) {
        return switch (button) {
            case 23 -> {
                float value = this.getLThumbStickYValue();
                if (value < 0.0f) {
                    yield -value;
                }
                yield 0.0f;
            }
            case 24 -> {
                float value = this.getLThumbStickYValue();
                if (value > 0.0f) {
                    yield value;
                }
                yield 0.0f;
            }
            case 25 -> {
                float value = this.getLThumbStickXValue();
                if (value < 0.0f) {
                    yield -value;
                }
                yield 0.0f;
            }
            case 26 -> {
                float value = this.getLThumbStickXValue();
                if (value > 0.0f) {
                    yield value;
                }
                yield 0.0f;
            }
            case 27 -> {
                float value = this.getRThumbStickYValue();
                if (value < 0.0f) {
                    yield -value;
                }
                yield 0.0f;
            }
            case 28 -> {
                float value = this.getRThumbStickYValue();
                if (value > 0.0f) {
                    yield value;
                }
                yield 0.0f;
            }
            case 29 -> {
                float value = this.getRThumbStickXValue();
                if (value < 0.0f) {
                    yield -value;
                }
                yield 0.0f;
            }
            case 30 -> {
                float value = this.getRThumbStickXValue();
                if (value > 0.0f) {
                    yield value;
                }
                yield 0.0f;
            }
            default -> button != -1 && this.isButtonPressed(button) ? 1.0f : 0.0f;
        };
    }

    public final boolean isAccessible() {
        Minecraft mc = Minecraft.getInstance();
        return mc.isWindowActive() || (Boolean)Config.CLIENT.options.backgroundInput.get() != false;
    }

    protected float getTriggerDeadzone() {
        return ((Double)Config.CLIENT.options.triggerDeadZone.get()).floatValue();
    }

    @Deprecated
    protected float getThumbstickDeadzone() {
        return ((Double)Config.CLIENT.options.thumbstickDeadZone.get()).floatValue();
    }

    protected float getThumbstickDeadzone(Thumbstick thumbstick) {
        if (((Boolean)Config.CLIENT.options.advanced.advancedMode.get()).booleanValue()) {
            return switch (thumbstick) {
                default -> throw new MatchException(null, null);
                case Thumbstick.LEFT -> ((Double)Config.CLIENT.options.advanced.leftThumbstickDeadZone.get()).floatValue();
                case Thumbstick.RIGHT -> ((Double)Config.CLIENT.options.advanced.rightThumbstickDeadZone.get()).floatValue();
            };
        }
        return ((Double)Config.CLIENT.options.thumbstickDeadZone.get()).floatValue();
    }
}

