/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public record DeviceInfo(@Nullable String name, @Nullable String guid, @Nullable String serial, int type, int vendor, int product, int productVersion, int firmware, int buttons, int axes) {
    public static final DeviceInfo EMPTY = new DeviceInfo(null, null, null, -1, -1, -1, -1, -1, -1, -1);

    @Nullable
    public static DeviceInfo fromJson(JsonElement element) {
        if (!element.isJsonObject()) {
            return null;
        }
        JsonObject object = (JsonObject)element;
        String name = GsonHelper.getAsString((JsonObject)object, (String)"name", null);
        String guid = GsonHelper.getAsString((JsonObject)object, (String)"guid", null);
        String serial = GsonHelper.getAsString((JsonObject)object, (String)"serial", null);
        int type = GsonHelper.getAsInt((JsonObject)object, (String)"type", (int)-1);
        int vendor = GsonHelper.getAsInt((JsonObject)object, (String)"vendor", (int)-1);
        int product = GsonHelper.getAsInt((JsonObject)object, (String)"product", (int)-1);
        int productVersion = GsonHelper.getAsInt((JsonObject)object, (String)"product_version", (int)-1);
        int firmware = GsonHelper.getAsInt((JsonObject)object, (String)"firmware", (int)-1);
        int buttons = GsonHelper.getAsInt((JsonObject)object, (String)"buttons", (int)-1);
        int axes = GsonHelper.getAsInt((JsonObject)object, (String)"axes", (int)-1);
        return new DeviceInfo(name, guid, serial, type, vendor, product, productVersion, firmware, buttons, axes);
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        if (this.name != null) {
            object.addProperty("name", this.name);
        }
        if (this.guid != null) {
            object.addProperty("guid", this.guid);
        }
        if (this.serial != null) {
            object.addProperty("serial", this.serial);
        }
        if (this.type != -1) {
            object.addProperty("type", (Number)this.type);
        }
        if (this.vendor != -1) {
            object.addProperty("vendor", (Number)this.vendor);
        }
        if (this.product != -1) {
            object.addProperty("product", (Number)this.product);
        }
        if (this.productVersion != -1) {
            object.addProperty("product_version", (Number)this.productVersion);
        }
        if (this.firmware != -1) {
            object.addProperty("firmware", (Number)this.firmware);
        }
        if (this.buttons != -1) {
            object.addProperty("buttons", (Number)this.buttons);
        }
        if (this.axes != -1) {
            object.addProperty("axes", (Number)this.axes);
        }
        return object;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo that = (DeviceInfo)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.axes != that.axes) {
            return false;
        }
        if (this.vendor != that.vendor) {
            return false;
        }
        if (this.product != that.product) {
            return false;
        }
        if (this.productVersion != that.productVersion) {
            return false;
        }
        if (this.firmware != that.firmware) {
            return false;
        }
        if (this.buttons != that.buttons) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.guid, that.guid)) {
            return false;
        }
        return Objects.equals(this.serial, that.serial);
    }
}

