/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input;

import com.mrcrayfish.controllable.client.input.ButtonStates;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.DeviceInfo;
import java.util.List;
import java.util.function.Function;

public final class MultiController
extends Controller {
    private final List<Controller> controllers;

    MultiController(List<Controller> controllers) {
        this.controllers = controllers;
    }

    public List<Controller> getControllers() {
        return this.controllers;
    }

    @Override
    public boolean open() {
        this.controllers.forEach(Controller::open);
        return true;
    }

    @Override
    public void close() {
        this.controllers.forEach(Controller::close);
    }

    @Override
    public Number getJid() {
        return -1;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public ButtonStates captureButtonStates() {
        ButtonStates result = new ButtonStates();
        for (Controller controller : this.controllers) {
            ButtonStates captured = controller.captureButtonStates();
            for (int i = 0; i < captured.getSize(); ++i) {
                if (!captured.getState(i)) continue;
                result.setState(i, true);
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return "Multi Controller";
    }

    @Override
    public boolean supportsRumble() {
        return true;
    }

    @Override
    protected boolean internalRumble(float lowFrequency, float highFrequency, int timeInMs) {
        for (Controller controller : this.controllers) {
            if (!controller.supportsRumble()) continue;
            controller.internalRumble(lowFrequency, highFrequency, timeInMs);
        }
        return false;
    }

    private float averageOfInput(Function<Controller, Float> func) {
        int count = 0;
        float total = 0.0f;
        for (Controller controller : this.controllers) {
            float value = func.apply(controller).floatValue();
            if (value == 0.0f) continue;
            total += value;
            ++count;
        }
        return count > 0 ? total / (float)count : 0.0f;
    }

    @Override
    protected float internalGetLTriggerValue() {
        return this.averageOfInput(Controller::internalGetLTriggerValue);
    }

    @Override
    protected float internalGetRTriggerValue() {
        return this.averageOfInput(Controller::internalGetRTriggerValue);
    }

    @Override
    protected float internalGetLThumbStickXValue() {
        return this.averageOfInput(Controller::internalGetLThumbStickXValue);
    }

    @Override
    protected float internalGetLThumbStickYValue() {
        return this.averageOfInput(Controller::internalGetLThumbStickYValue);
    }

    @Override
    protected float internalGetRThumbStickXValue() {
        return this.averageOfInput(Controller::internalGetRThumbStickXValue);
    }

    @Override
    protected float internalGetRThumbStickYValue() {
        return this.averageOfInput(Controller::internalGetRThumbStickYValue);
    }

    @Override
    public DeviceInfo getInfo() {
        return null;
    }
}

