/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input.glfw;

import com.mrcrayfish.controllable.client.input.ButtonStates;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.DeviceInfo;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.Mth;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;

public class GLFWController
extends Controller {
    private final int deviceIndex;
    private GLFWGamepadState controller;
    private String cachedName;
    private DeviceInfo info;

    public GLFWController(int deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    @Override
    public boolean open() {
        this.controller = GLFWGamepadState.create();
        return true;
    }

    @Override
    public void close() {
        this.controller.close();
        this.controller = null;
    }

    @Override
    public Number getJid() {
        return this.deviceIndex;
    }

    @Override
    public boolean isOpen() {
        return this.controller != null && GLFW.glfwJoystickPresent((int)this.deviceIndex);
    }

    @Override
    public ButtonStates captureButtonStates() {
        GLFW.glfwGetGamepadState((int)this.deviceIndex, (GLFWGamepadState)this.controller);
        ButtonStates states = new ButtonStates();
        states.setState(0, this.readButton(0));
        states.setState(1, this.readButton(1));
        states.setState(2, this.readButton(2));
        states.setState(3, this.readButton(3));
        states.setState(4, this.readButton(6));
        states.setState(5, this.readButton(8));
        states.setState(6, this.readButton(7));
        states.setState(7, this.readButton(9));
        states.setState(8, this.readButton(10));
        states.setState(9, this.readButton(4));
        states.setState(10, this.readButton(5));
        states.setState(11, this.getLTriggerValue() >= 0.5f);
        states.setState(12, this.getRTriggerValue() >= 0.5f);
        states.setState(13, this.readButton(11));
        states.setState(14, this.readButton(13));
        states.setState(15, this.readButton(14));
        states.setState(16, this.readButton(12));
        states.setState(23, this.getLThumbStickYValue() <= -0.5f);
        states.setState(24, this.getLThumbStickYValue() >= 0.5f);
        states.setState(25, this.getLThumbStickXValue() <= -0.5f);
        states.setState(26, this.getLThumbStickXValue() >= 0.5f);
        states.setState(27, this.getRThumbStickYValue() <= -0.5f);
        states.setState(28, this.getRThumbStickYValue() >= 0.5f);
        states.setState(29, this.getRThumbStickXValue() <= -0.5f);
        states.setState(30, this.getRThumbStickXValue() >= 0.5f);
        return states;
    }

    private boolean readButton(int button) {
        return this.controller.buttons(button) == 1;
    }

    @Override
    public String getName() {
        if (GLFW.glfwJoystickPresent((int)this.deviceIndex)) {
            if (this.cachedName == null) {
                this.cachedName = GLFW.glfwGetGamepadName((int)this.deviceIndex);
            }
            return this.cachedName;
        }
        return I18n.get((String)"controllable.toast.controller", (Object[])new Object[0]);
    }

    @Override
    public boolean supportsRumble() {
        return false;
    }

    @Override
    protected boolean internalRumble(float lowFrequency, float highFrequency, int timeInMs) {
        return false;
    }

    @Override
    protected float internalGetLTriggerValue() {
        return Mth.clamp((float)((this.controller.axes(4) + 1.0f) / 2.0f), (float)0.0f, (float)1.0f);
    }

    @Override
    protected float internalGetRTriggerValue() {
        return Mth.clamp((float)((this.controller.axes(5) + 1.0f) / 2.0f), (float)0.0f, (float)1.0f);
    }

    @Override
    protected float internalGetLThumbStickXValue() {
        return Mth.clamp((float)this.controller.axes(0), (float)-1.0f, (float)1.0f);
    }

    @Override
    protected float internalGetLThumbStickYValue() {
        return Mth.clamp((float)this.controller.axes(1), (float)-1.0f, (float)1.0f);
    }

    @Override
    protected float internalGetRThumbStickXValue() {
        return Mth.clamp((float)this.controller.axes(2), (float)-1.0f, (float)1.0f);
    }

    @Override
    protected float internalGetRThumbStickYValue() {
        return Mth.clamp((float)this.controller.axes(3), (float)-1.0f, (float)1.0f);
    }

    @Override
    public DeviceInfo getInfo() {
        if (this.info == null) {
            String name = GLFW.glfwGetGamepadName((int)this.deviceIndex);
            String guid = GLFW.glfwGetJoystickGUID((int)this.deviceIndex);
            this.info = new DeviceInfo(name, guid, null, -1, -1, -1, -1, -1, -1, -1);
        }
        return this.info;
    }
}

