/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input.glfw;

import com.google.common.io.ByteStreams;
import com.mrcrayfish.controllable.Constants;
import com.mrcrayfish.controllable.client.input.AdaptiveControllerManager;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.DeviceInfo;
import com.mrcrayfish.controllable.client.input.glfw.GLFWController;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

public class GLFWControllerManager
extends AdaptiveControllerManager {
    @Override
    public void init() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public Controller createController(int deviceIndex, Number jid) {
        return new GLFWController(jid.intValue());
    }

    @Override
    @Nullable
    public Controller connectToBestGameController() {
        List<DeviceInfo> lastDevices = this.getLastDevices();
        if (!lastDevices.isEmpty()) {
            ArrayList<GLFWController> selectedControllers = new ArrayList<GLFWController>();
            List availableControllers = IntStream.rangeClosed(0, 15).filter(jid -> GLFW.glfwJoystickPresent((int)jid) && GLFW.glfwJoystickIsGamepad((int)jid)).mapToObj(GLFWController::new).collect(Collectors.toCollection(ArrayList::new));
            for (DeviceInfo info : lastDevices) {
                Iterator it = availableControllers.iterator();
                while (it.hasNext()) {
                    GLFWController controller = (GLFWController)it.next();
                    if (!controller.getInfo().equals(info)) continue;
                    selectedControllers.add(controller);
                    it.remove();
                }
            }
            selectedControllers.forEach(this::addActiveController);
            Controller controller = this.getActiveController();
            if (controller != null) {
                return controller;
            }
        }
        for (int jid2 = 0; jid2 <= 15; ++jid2) {
            GLFWController controller;
            if (!GLFW.glfwJoystickPresent((int)jid2) || !GLFW.glfwJoystickIsGamepad((int)jid2) || !this.setActiveController(controller = new GLFWController(jid2))) continue;
            return controller;
        }
        return null;
    }

    @Override
    public void updateMappings(InputStream is) throws IOException {
        byte[] bytes;
        ByteBuffer buffer;
        if (is != null && (buffer = MemoryUtil.memASCIISafe((CharSequence)new String(bytes = ByteStreams.toByteArray((InputStream)is)))) != null && GLFW.glfwUpdateGamepadMappings((ByteBuffer)buffer)) {
            Constants.LOG.info("Successfully updated gamepad mappings");
            return;
        }
        Constants.LOG.info("No gamepad mappings were updated");
    }

    @Override
    protected int getRawControllerCount() {
        int connectedCount = 0;
        for (int jid = 0; jid <= 15; ++jid) {
            if (!GLFW.glfwJoystickIsGamepad((int)jid)) continue;
            ++connectedCount;
        }
        return connectedCount;
    }

    @Override
    protected Map<Number, Pair<Integer, String>> createRawControllerMap() {
        HashMap<Number, Pair<Integer, String>> controllers = new HashMap<Number, Pair<Integer, String>>();
        for (int jid = 0; jid <= 15; ++jid) {
            if (!GLFW.glfwJoystickIsGamepad((int)jid)) continue;
            String controllerName = GLFW.glfwGetGamepadName((int)jid);
            controllers.put(jid, (Pair<Integer, String>)Pair.of((Object)jid, (Object)controllerName));
        }
        return controllers;
    }
}

