/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.input.sdl2;

import com.google.common.io.ByteStreams;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Constants;
import com.mrcrayfish.controllable.client.input.AdaptiveControllerManager;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.DeviceInfo;
import com.mrcrayfish.controllable.client.input.sdl2.SDL2Controller;
import com.mrcrayfish.controllable.util.Utils;
import com.mrcrayfish.controllable_sdl.api.Sdl;
import com.mrcrayfish.controllable_sdl.api.gamecontroller.SdlGamecontroller;
import com.mrcrayfish.controllable_sdl.api.hints.SdlHints;
import com.mrcrayfish.controllable_sdl.api.joystick.SDL_JoystickID;
import com.mrcrayfish.controllable_sdl.api.joystick.SdlJoystick;
import com.mrcrayfish.controllable_sdl.api.rwops.SDL_RWops;
import com.mrcrayfish.controllable_sdl.api.rwops.SdlRWops;
import com.mrcrayfish.controllable_sdl.jna.SdlNativeLibraryLoader;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SDL2ControllerManager
extends AdaptiveControllerManager {
    private boolean lastBackgroundInput;

    @Override
    public void init() {
        if (((Boolean)Config.CLIENT.options.backgroundInput.get()).booleanValue()) {
            SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_ALLOW_BACKGROUND_EVENTS", (String)"1");
            this.lastBackgroundInput = true;
        }
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_VERTICAL_JOY_CONS", (String)"1");
        Sdl.SDL_Init((int)8704);
    }

    @Override
    public void dispose() {
        Sdl.SDL_Quit();
    }

    @Override
    public SDL2Controller createController(int deviceIndex, Number jid) {
        return new SDL2Controller(deviceIndex);
    }

    @Override
    protected int getRawControllerCount() {
        int controllerCount = 0;
        int joysticksCount = SdlJoystick.SDL_NumJoysticks();
        for (int deviceIndex = 0; deviceIndex < joysticksCount; ++deviceIndex) {
            if (!SdlGamecontroller.SDL_IsGameController((int)deviceIndex)) continue;
            ++controllerCount;
        }
        return controllerCount;
    }

    @Override
    protected Map<Number, Pair<Integer, String>> createRawControllerMap() {
        HashMap<Number, Pair<Integer, String>> controllers = new HashMap<Number, Pair<Integer, String>>();
        int joysticksCount = SdlJoystick.SDL_NumJoysticks();
        for (int deviceIndex = 0; deviceIndex < joysticksCount; ++deviceIndex) {
            if (!SdlGamecontroller.SDL_IsGameController((int)deviceIndex)) continue;
            SDL_JoystickID jid = SdlJoystick.SDL_JoystickGetDeviceInstanceID((int)deviceIndex);
            String controllerName = SdlGamecontroller.SDL_GameControllerNameForIndex((int)deviceIndex);
            controllers.put((Number)jid, (Pair<Integer, String>)Pair.of((Object)deviceIndex, (Object)controllerName));
        }
        return controllers;
    }

    @Override
    @Nullable
    public Controller connectToBestGameController() {
        Controller controller;
        List<DeviceInfo> lastDevices = this.getLastDevices();
        if (!lastDevices.isEmpty()) {
            ArrayList<SDL2Controller> selectedControllers = new ArrayList<SDL2Controller>();
            List availableControllers = IntStream.range(0, SdlJoystick.SDL_NumJoysticks()).filter(SdlGamecontroller::SDL_IsGameController).mapToObj(SDL2Controller::new).collect(Collectors.toCollection(ArrayList::new));
            for (DeviceInfo info : lastDevices) {
                Iterator it = availableControllers.iterator();
                while (it.hasNext()) {
                    SDL2Controller controller2 = (SDL2Controller)it.next();
                    controller2.open();
                    if (controller2.getInfo().equals(info)) {
                        selectedControllers.add(controller2);
                        it.remove();
                    }
                    controller2.close();
                }
            }
            selectedControllers.forEach(this::addActiveController);
            controller = this.getActiveController();
            if (controller != null) {
                return controller;
            }
        }
        int joysticksCount = SdlJoystick.SDL_NumJoysticks();
        for (int deviceIndex = 0; deviceIndex < joysticksCount; ++deviceIndex) {
            if (!SdlGamecontroller.SDL_IsGameController((int)deviceIndex) || !this.setActiveController(controller = new SDL2Controller(deviceIndex))) continue;
            return controller;
        }
        return null;
    }

    @Override
    public void updateMappings(InputStream is) throws IOException {
        byte[] bytes = ByteStreams.toByteArray((InputStream)is);
        try (Memory memory = new Memory((long)bytes.length);){
            memory.write(0L, bytes, 0, bytes.length);
            SDL_RWops wops = SdlRWops.SDL_RWFromConstMem((Pointer)memory, (int)((int)memory.size()));
            int count = SdlGamecontroller.SDL_GameControllerAddMappingsFromRW((SDL_RWops)wops, (int)1);
            if (count > 0) {
                Constants.LOG.info("Successfully updated {} gamepad mappings", (Object)count);
                return;
            }
        }
        Constants.LOG.info("No gamepad mappings were updated");
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastBackgroundInput != (Boolean)Config.CLIENT.options.backgroundInput.get()) {
            this.lastBackgroundInput = (Boolean)Config.CLIENT.options.backgroundInput.get();
            String value = this.lastBackgroundInput ? "1" : "0";
            SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_ALLOW_BACKGROUND_EVENTS", (String)value);
        }
    }

    static {
        try {
            Path natives = Utils.getGamePath().resolve("controllable_natives");
            Path sdl = natives.resolve("SDL");
            Files.createDirectories(sdl, new FileAttribute[0]);
            SdlNativeLibraryLoader.setExtractionPath((Path)sdl);
            Path readMeFile = natives.resolve("README.txt");
            if (!Files.exists(readMeFile, new LinkOption[0])) {
                Files.writeString(readMeFile, (CharSequence)"This directory holds the natives for Controllable, which are used to interface\nwith game controllers and read their inputs. It is safe to delete, just make sure\nthe game is closed as the natives may be loaded; preventing you from deleting them.\nIf you are developing a modpack, make sure to exclude this directory.", new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

