/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.overlay;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.overlay.IOverlay;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;

public class TabNavigationOverlay
implements IOverlay {
    private TabNavigationBar navigationBar;

    @Override
    public void tick() {
        this.navigationBar = null;
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen != null) {
            this.navigationBar = screen.children().stream().filter(e -> e instanceof TabNavigationBar).map(listener -> (TabNavigationBar)listener).findFirst().orElse(null);
        }
    }

    @Override
    public boolean isVisible() {
        Controller controller = Controllable.getController();
        return controller != null && ((Boolean)Config.CLIENT.options.overlayTimeout.get() == false || controller.isBeingUsed()) && this.navigationBar != null;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, DeltaTracker tracker) {
        List tabs = this.navigationBar.children();
        ScreenRectangle firstTab = ((GuiEventListener)tabs.get(0)).getRectangle();
        ClientHelper.drawButton(graphics, firstTab.left() - 18, (firstTab.height() - 11) / 2, ButtonBindings.NEXT_RECIPE_TAB.getButton());
        ScreenRectangle lastTab = ((GuiEventListener)tabs.get(tabs.size() - 1)).getRectangle();
        ClientHelper.drawButton(graphics, lastTab.right() + 5, (lastTab.height() - 11) / 2, ButtonBindings.PREVIOUS_RECIPE_TAB.getButton());
    }
}

