/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.gui.Icons;
import com.mrcrayfish.controllable.client.settings.ButtonIcons;
import com.mrcrayfish.controllable.mixin.client.OverlayRecipeButtonAccessor;
import com.mrcrayfish.controllable.mixin.client.OverlayRecipeComponentAccessor;
import com.mrcrayfish.controllable.platform.ClientServices;
import com.mrcrayfish.controllable.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.recipebook.OverlayRecipeComponent;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ClientHelper {
    public static final ResourceLocation ICON_FONT = Utils.resource("icons");
    public static final ResourceLocation BUTTON_FONT = Utils.resource("buttons");

    public static MutableComponent getIconComponent(Icons icon) {
        MutableComponent component = Component.literal((String)String.valueOf((char)(33 + icon.ordinal())));
        component.setStyle(component.getStyle().withColor(ChatFormatting.WHITE).withFont(ICON_FONT));
        return component;
    }

    public static MutableComponent getButtonComponent(int button) {
        MutableComponent component = Component.literal((String)String.valueOf((char)(33 + (((ButtonIcons)Config.CLIENT.options.controllerIcons.get()).ordinal() * 31 + button))));
        component.setStyle(component.getStyle().withColor(ChatFormatting.WHITE).withFont(BUTTON_FONT));
        return component;
    }

    public static MutableComponent join(int button, Component label) {
        return Component.empty().append((Component)ClientHelper.getButtonComponent(button)).append(" ").append(label);
    }

    public static MutableComponent join(Icons icon, Component label) {
        return Component.empty().append((Component)ClientHelper.getIconComponent(icon)).append(" ").append(label);
    }

    public static void drawButton(GuiGraphics graphics, int x, int y, int button) {
        int texU = button * 13;
        int texV = ((ButtonIcons)Config.CLIENT.options.controllerIcons.get()).ordinal() * 13;
        int size = 13;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(ButtonIcons.TEXTURE, x, y, (float)texU, (float)texV, size, size, 403, ButtonIcons.TEXTURE_HEIGHT);
    }

    public static boolean isPlayingGame() {
        Minecraft mc = Minecraft.getInstance();
        return mc.getConnection() != null && mc.getConnection().isAcceptingMessages();
    }

    public static <T extends FormattedText> Tooltip createListTooltip(List<T> lines) {
        List charSequenceList = Language.getInstance().getVisualOrder(lines);
        Tooltip blank = Tooltip.create((Component)CommonComponents.EMPTY);
        ClientServices.CLIENT.pushLinesToTooltip(blank, charSequenceList);
        return blank;
    }

    public static Component getOptionName(OptionInstance<Boolean> option) {
        return ClientServices.CLIENT.getOptionInstanceName(option);
    }

    public static Tooltip getOptionTooltip(OptionInstance<Boolean> option) {
        return ClientServices.CLIENT.getOptionInstanceTooltip(option);
    }

    public static boolean isChatVisible() {
        Minecraft mc = Minecraft.getInstance();
        List<GuiMessage.Line> messages = ClientServices.CLIENT.getChatTrimmedMessages(mc.gui.getChat());
        return mc.screen == null && messages.stream().anyMatch(chatLine -> mc.gui.getGuiTicks() - chatLine.addedTime() < 200);
    }

    public static boolean isSubtitleShowing() {
        Minecraft mc = Minecraft.getInstance();
        return (Boolean)mc.options.showSubtitles().get() != false && mc.screen == null;
    }

    public static List<AbstractWidget> mixinGetRecipeButtons(OverlayRecipeComponent overlay) {
        if (overlay instanceof OverlayRecipeComponentAccessor) {
            OverlayRecipeComponentAccessor accessor = (OverlayRecipeComponentAccessor)overlay;
            return accessor.controllableGetRecipeButtons();
        }
        return Collections.emptyList();
    }

    public static boolean mixinIsCraftable(AbstractWidget widget) {
        if (widget instanceof OverlayRecipeButtonAccessor) {
            OverlayRecipeButtonAccessor accessor = (OverlayRecipeButtonAccessor)widget;
            return accessor.controllableIsCraftable();
        }
        return false;
    }
}

