/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.util;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.Window;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.integration.EmiSupport;
import com.mrcrayfish.controllable.platform.ClientServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;

public class MouseHooks {
    private static double getScreenMouseX() {
        if (Controllable.getCursor().isEnabled()) {
            return Controllable.getCursor().getScreenX();
        }
        Window window = Minecraft.getInstance().getWindow();
        double x = Minecraft.getInstance().mouseHandler.xpos();
        return x * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
    }

    private static double getScreenMouseY() {
        if (Controllable.getCursor().isEnabled()) {
            return Controllable.getCursor().getScreenY();
        }
        Window window = Minecraft.getInstance().getWindow();
        double y = Minecraft.getInstance().mouseHandler.ypos();
        return y * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
    }

    public static void invokeMouseClick(Screen screen, int button) {
        if (screen != null) {
            double screenCursorX = MouseHooks.getScreenMouseX();
            double screenCursorY = MouseHooks.getScreenMouseY();
            if (screen instanceof AbstractContainerScreen && Controllable.isEmiLoaded() && EmiSupport.invokeMouseClick(button, screenCursorX, screenCursorY)) {
                return;
            }
            MouseHooks.invokeMouseClick(screen, button, screenCursorX, screenCursorY);
        }
    }

    public static void invokeMouseClick(Screen screen, int button, double cursorScreenX, double cursorScreenY) {
        if (screen != null) {
            ClientServices.CLIENT.setActiveMouseButton(button);
            ClientServices.CLIENT.setLastMouseEventTime(Blaze3D.getTime());
            ClientServices.CLIENT.sendScreenMouseClick(screen, cursorScreenX, cursorScreenY, button);
        }
    }

    public static void invokeMouseReleased(Screen screen, int button) {
        if (screen != null) {
            double screenCursorX = MouseHooks.getScreenMouseX();
            double screenCursorY = MouseHooks.getScreenMouseY();
            if (screen instanceof AbstractContainerScreen && Controllable.isEmiLoaded() && EmiSupport.invokeMouseReleased(button, screenCursorX, screenCursorY)) {
                return;
            }
            MouseHooks.invokeMouseReleased(screen, button, screenCursorX, screenCursorY);
        }
    }

    public static void invokeMouseReleased(Screen screen, int button, double cursorScreenX, double cursorScreenY) {
        if (screen != null) {
            ClientServices.CLIENT.setActiveMouseButton(-1);
            ClientServices.CLIENT.sendScreenMouseReleased(screen, cursorScreenX, cursorScreenY, button);
        }
    }

    public static void invokeMouseMoved(Screen screen, double cursorX, double cursorY, double deltaX, double deltaY) {
        Minecraft mc = Minecraft.getInstance();
        if (screen != null && mc.getOverlay() == null) {
            double screenCursorX = cursorX * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getWidth();
            double screenCursorY = cursorY * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getHeight();
            Screen.wrapScreenError(() -> screen.mouseMoved(screenCursorX, screenCursorY), (String)"Controllable mouseMoved event handler", (String)screen.getClass().getCanonicalName());
            int activeMouseButton = ClientServices.CLIENT.getActiveMouseButton();
            double lastMouseEventTime = ClientServices.CLIENT.getLastMouseEventTime();
            if (activeMouseButton != -1 && lastMouseEventTime > 0.0) {
                if (screen instanceof AbstractContainerScreen && Controllable.isEmiLoaded() && EmiSupport.invokeMouseDragged(activeMouseButton, screenCursorX, screenCursorY, deltaX, deltaY)) {
                    return;
                }
                ClientServices.CLIENT.sendMouseDrag(screen, deltaX, deltaY, screenCursorX, screenCursorY, activeMouseButton);
            }
        }
    }
}

