/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.util;

import com.mrcrayfish.controllable.mixin.client.RecipeBookComponentAccessor;
import com.mrcrayfish.controllable.mixin.client.RecipeBookPageAccessor;
import com.mrcrayfish.controllable.platform.ClientServices;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;

public class ScreenHelper {
    public static boolean isMouseWithin(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static Button button(int x, int y, int width, int height, Component label, Button.OnPress onPress) {
        return Button.builder((Component)label, (Button.OnPress)onPress).pos(x, y).size(width, height).build();
    }

    public static void drawOutlinedBox(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.fill(x, y, x + width, y + 1, color);
        graphics.fill(x, y + 1, x + 1, y + height - 1, color);
        graphics.fill(x, y + height - 1, x + width, y + height, color);
        graphics.fill(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public static void drawRoundedBox(GuiGraphics graphics, int x, int y, int width, int height, int backgroundColor) {
        graphics.fill(x - 3 + 1, y, x + width + 2 - 1, y + 1, backgroundColor);
        graphics.fill(x - 3, y + 1, x + width + 2, y + height - 1, backgroundColor);
        graphics.fill(x - 3 + 1, y + height - 1, x + width + 2 - 1, y + height, backgroundColor);
    }

    public static Optional<GuiEventListener> findHoveredListener(Screen screen, double mouseX, double mouseY, Predicate<GuiEventListener> condition) {
        return ScreenHelper.findHoveredListener(screen.children(), mouseX, mouseY, condition);
    }

    private static Optional<GuiEventListener> findHoveredListener(List<? extends GuiEventListener> listeners, double mouseX, double mouseY, Predicate<GuiEventListener> condition) {
        for (GuiEventListener guiEventListener : listeners) {
            TabButton button;
            if (condition.test(guiEventListener) && guiEventListener.isMouseOver(mouseX, mouseY)) {
                return Optional.of(guiEventListener);
            }
            if (guiEventListener instanceof TabButton && (button = (TabButton)guiEventListener).isSelected()) {
                ArrayList children = new ArrayList();
                button.tab().visitChildren(children::add);
                return ScreenHelper.findHoveredListener(children, mouseX, mouseY, condition);
            }
            if (!(guiEventListener instanceof ContainerEventHandler)) continue;
            ContainerEventHandler handler = (ContainerEventHandler)guiEventListener;
            return ScreenHelper.findHoveredListener(handler.children(), mouseX, mouseY, condition);
        }
        return Optional.empty();
    }

    public static Optional<GuiEventListener> findHoveredEventListenerExcludeList(ContainerEventHandler handler, double mouseX, double mouseY) {
        Optional<GuiEventListener> hovered = ScreenHelper.findHoveredEventListenerExcludeList(handler.children(), mouseX, mouseY);
        if (hovered.isPresent()) {
            return hovered;
        }
        return ScreenHelper.findHoveredEventListenerInRecipeBook(handler, mouseX, mouseY);
    }

    public static Optional<GuiEventListener> findHoveredEventListenerExcludeList(List<? extends GuiEventListener> listeners, double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : listeners) {
            if (!guiEventListener.isMouseOver(mouseX, mouseY)) continue;
            GuiEventListener guiEventListener2 = guiEventListener;
            Objects.requireNonNull(guiEventListener2);
            GuiEventListener guiEventListener22 = guiEventListener2;
            int n = 0;
            block6: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractSelectionList.class, TabButton.class, ContainerEventHandler.class}, (Object)guiEventListener22, n)) {
                    case 0: {
                        AbstractSelectionList list = (AbstractSelectionList)guiEventListener22;
                        return ScreenHelper.findHoveredEventListenerFromListEntries(list, mouseX, mouseY);
                    }
                    case 1: {
                        TabButton button = (TabButton)guiEventListener22;
                        if (!button.isSelected()) {
                            n = 2;
                            continue block6;
                        }
                        ArrayList children = new ArrayList();
                        button.tab().visitChildren(children::add);
                        return ScreenHelper.findHoveredEventListenerExcludeList(children, mouseX, mouseY);
                    }
                    case 2: {
                        ContainerEventHandler handler = (ContainerEventHandler)guiEventListener22;
                        return ScreenHelper.findHoveredEventListenerExcludeList(handler.children(), mouseX, mouseY);
                    }
                }
                break;
            }
            return Optional.of(guiEventListener);
        }
        return Optional.empty();
    }

    private static Optional<GuiEventListener> findHoveredEventListenerFromListEntries(AbstractSelectionList<?> list, double mouseX, double mouseY) {
        List entries = list.children();
        for (int index = 0; index < entries.size(); ++index) {
            Object entry;
            int rowTop = ClientServices.CLIENT.getAbstractListRowTop(list, index);
            int rowBottom = ClientServices.CLIENT.getAbstractListRowBottom(list, index);
            int listTop = ClientServices.CLIENT.getAbstractListTop(list);
            int listBottom = ClientServices.CLIENT.getAbstractListBottom(list);
            if (rowTop < listTop && rowBottom > listBottom || !((entry = entries.get(index)) instanceof ContainerEventHandler)) continue;
            ContainerEventHandler handler = (ContainerEventHandler)entry;
            return ScreenHelper.findHoveredEventListenerExcludeList(handler, mouseX, mouseY);
        }
        return Optional.empty();
    }

    private static Optional<GuiEventListener> findHoveredEventListenerInRecipeBook(ContainerEventHandler handler, double mouseX, double mouseY) {
        RecipeUpdateListener listener;
        RecipeBookComponent recipeBook;
        if (handler instanceof RecipeUpdateListener && (recipeBook = (listener = (RecipeUpdateListener)handler).getRecipeBookComponent()).isVisible()) {
            ArrayList<Object> listeners = new ArrayList<Object>();
            RecipeBookComponentAccessor bookAccessor = (RecipeBookComponentAccessor)recipeBook;
            listeners.add(bookAccessor.controllableGetFilterButton());
            listeners.addAll(bookAccessor.controllableGetRecipeTabs());
            RecipeBookPageAccessor pageAccessor = (RecipeBookPageAccessor)bookAccessor.controllableGetRecipeBookPage();
            listeners.addAll(pageAccessor.controllableGetButtons());
            listeners.add(pageAccessor.controllableGetForwardButton());
            listeners.add(pageAccessor.controllableGetBackButton());
            return listeners.stream().filter(o -> o != null && o.isMouseOver(mouseX, mouseY)).findFirst();
        }
        return Optional.empty();
    }
}

