/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.integration;

import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.TabContainerWidget;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;

public class ReiSupport {
    private static final Field tabsField = ReiSupport.getField(AbstractDisplayViewingScreen.class, "tabs");

    public static List<NavigationPoint> getNavigationPoints(Screen screen) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return Collections.emptyList();
        }
        ArrayList<NavigationPoint> points = new ArrayList<NavigationPoint>();
        REIRuntime.getInstance().getOverlay().ifPresent(overlay -> {
            if (overlay.getBounds().isEmpty()) {
                return;
            }
            ReiSupport.scanWidgets(points, overlay);
            ReiSupport.scanWidgets(points, overlay.getEntryList());
        });
        if (screen instanceof AbstractDisplayViewingScreen) {
            AbstractDisplayViewingScreen s1 = (AbstractDisplayViewingScreen)screen;
            ReiSupport.scanWidgets(points, ReiSupport.getTabs(s1));
            if (s1 instanceof DefaultDisplayViewingScreen) {
                DefaultDisplayViewingScreen s2 = (DefaultDisplayViewingScreen)s1;
                for (Widget widget : s2.widgets()) {
                    ReiSupport.scanWidgets(points, widget);
                }
            }
        }
        return points;
    }

    private static void scanWidgets(List<NavigationPoint> points, Object obj) {
        WidgetWithBounds widget;
        if (obj instanceof ContainerEventHandler) {
            ContainerEventHandler handler = (ContainerEventHandler)obj;
            for (GuiEventListener listener : handler.children()) {
                ReiSupport.scanWidgets(points, listener);
            }
        }
        if (obj instanceof TabContainerWidget) {
            TabContainerWidget container = (TabContainerWidget)obj;
            for (Widget widget2 : container.widgets()) {
                ReiSupport.scanWidgets(points, widget2);
            }
        } else if (obj instanceof WidgetWithBounds && ReiSupport.isValidWidgetType(widget = (WidgetWithBounds)obj)) {
            Rectangle box = widget.getBounds();
            points.add(new BasicNavigationPoint((double)box.x + (double)box.width / 2.0, (double)box.y + (double)box.height / 2.0));
        }
    }

    private static boolean isValidWidgetType(Object obj) {
        Slot slot;
        TabWidget tabWidget;
        Label label;
        if (obj instanceof Button) {
            return true;
        }
        if (obj instanceof EntryListStackEntry) {
            return true;
        }
        if (obj instanceof Label && (label = (Label)obj).isClickable()) {
            return true;
        }
        if (obj instanceof TabWidget && (tabWidget = (TabWidget)obj).isShown() && !tabWidget.bounds.isEmpty() && tabWidget.opacity > 0.0f) {
            return true;
        }
        return obj instanceof Slot && (slot = (Slot)obj).isInteractable();
    }

    private static TabContainerWidget getTabs(AbstractDisplayViewingScreen screen) {
        try {
            return (TabContainerWidget)tabsField.get(screen);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getField(Class<?> targetClass, String fieldName) {
        try {
            Field field = targetClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

