/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.binding.handlers.impl.AttackHandler;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.platform.ClientServices;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;

    @ModifyExpressionValue(method={"handleKeybinds"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z", ordinal=4)})
    private boolean modifyAttackKeyDown(boolean original) {
        Controller controller = Controllable.getController();
        if (controller != null && controller.isBeingUsed() && ButtonBindings.ATTACK.isButtonDown()) {
            controller.updateInputTime();
            return !AttackHandler.shouldPreventContinue();
        }
        return original;
    }

    @ModifyExpressionValue(method={"handleKeybinds"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z", ordinal=3)})
    private boolean modifyUseKeyDown(boolean original) {
        Controller controller = Controllable.getController();
        if (controller != null && controller.isBeingUsed() && ButtonBindings.USE_ITEM.isButtonDown()) {
            controller.updateInputTime();
            return true;
        }
        return original;
    }

    @ModifyExpressionValue(method={"handleKeybinds"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z", ordinal=2)})
    private boolean modifyReleaseUseKeyDown(boolean original) {
        Controller controller = Controllable.getController();
        if (controller != null && controller.isBeingUsed() && ButtonBindings.USE_ITEM.isButtonDown()) {
            controller.updateInputTime();
            return true;
        }
        return original;
    }

    @ModifyExpressionValue(method={"shouldEntityAppearGlowing"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z")})
    private boolean controllableIsEntityGlowing(boolean original) {
        return original || ButtonBindings.HIGHLIGHT_PLAYERS.isButtonDown();
    }

    @Inject(method={"isWindowActive"}, at={@At(value="HEAD")}, cancellable=true)
    private void controllableIsWindowActiveHead(CallbackInfoReturnable<Boolean> cir) {
        if (this.player != null && Controllable.getController() != null && ((Boolean)Config.CLIENT.options.backgroundInput.get()).booleanValue()) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"runTick"}, at=@At(value="STORE", target="Lnet/minecraft/client/Minecraft;getFramerateLimit()I"), index=7)
    private int controllableModifyFramerate(int originalFps) {
        Minecraft mc = (Minecraft)this;
        if (mc.getOverlay() == null && ((Boolean)Config.CLIENT.options.fpsPollingFix.get()).booleanValue() && ClientServices.CLIENT.getMinecraftFramerateLimit() < 40) {
            return 260;
        }
        return originalFps;
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getFramerateLimit()I")})
    private void controllableWaitEvents(boolean outOfMemory, CallbackInfo ci) {
        Minecraft mc = (Minecraft)this;
        if (mc.getOverlay() == null && ((Boolean)Config.CLIENT.options.fpsPollingFix.get()).booleanValue() && ClientServices.CLIENT.getMinecraftFramerateLimit() < 40) {
            Controllable.getInputProcessor().queueInputsWait();
        }
    }
}

