/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.mixin.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.input.Controller;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public abstract class MouseHelperMixin {
    @Unique
    private boolean controllable$releaseBypass;
    @Shadow
    private double accumulatedDX;
    @Shadow
    private double accumulatedDY;

    @Shadow
    public abstract void releaseMouse();

    @Inject(method={"handleAccumulatedMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MouseHandler;isMouseGrabbed()Z")}, cancellable=true)
    private void controllableBeforeUpdateLook(CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen != null && (Math.abs(this.accumulatedDX) > 0.0 || Math.abs(this.accumulatedDY) > 0.0)) {
            this.controllable$releaseBypass = true;
            this.releaseMouse();
            this.controllable$releaseBypass = false;
            this.accumulatedDX = 0.0;
            this.accumulatedDY = 0.0;
            ci.cancel();
        }
    }

    @Inject(method={"releaseMouse"}, at={@At(value="HEAD")}, cancellable=true)
    private void controllableGrabCursor(CallbackInfo ci) {
        Controller controller = Controllable.getController();
        if (controller != null && controller.isUsingVirtualCursor() && !this.controllable$releaseBypass) {
            ci.cancel();
        }
    }
}

