/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.platform;

import com.mrcrayfish.controllable.client.binding.context.BindingContext;
import com.mrcrayfish.controllable.client.binding.context.NeoForgeKeyContext;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.util.ReflectUtil;
import com.mrcrayfish.controllable.platform.ClientServices;
import com.mrcrayfish.controllable.platform.services.IClientHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.gui.CreativeTabsScreenPage;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;

public class ForgeClientHelper
implements IClientHelper {
    public final Map<IKeyConflictContext, BindingContext> keyContextMap = new Object2ObjectOpenHashMap();

    @Override
    public float getGuiFarPlane() {
        return ClientHooks.getGuiFarPlane();
    }

    @Override
    public boolean sendScreenInput(Screen screen, int key, int action, int modifiers) {
        AtomicBoolean handled = new AtomicBoolean();
        Screen.wrapScreenError(() -> {
            if (action == 0) {
                if (!(ClientHooks.onScreenKeyReleasedPre((Screen)screen, (int)key, (int)-1, (int)modifiers) || screen.keyReleased(key, -1, modifiers) || ClientHooks.onScreenKeyReleasedPost((Screen)screen, (int)key, (int)-1, (int)modifiers))) {
                    return;
                }
                handled.set(true);
            } else if (action == 1) {
                if (!(ClientHooks.onScreenKeyPressedPre((Screen)screen, (int)key, (int)-1, (int)modifiers) || screen.keyPressed(key, -1, modifiers) || ClientHooks.onScreenKeyPressedPost((Screen)screen, (int)key, (int)-1, (int)modifiers))) {
                    return;
                }
                handled.set(true);
            }
        }, (String)"Controllable keyPressed event handler", (String)screen.getClass().getCanonicalName());
        return handled.get();
    }

    @Override
    public void sendMouseDrag(Screen screen, double dragX, double dragY, double finalMouseX, double finalMouseY, int activeButton) {
        Screen.wrapScreenError(() -> {
            double finalDragY;
            Minecraft mc = screen.getMinecraft();
            double finalDragX = dragX * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getWidth();
            if (ClientHooks.onScreenMouseDragPre((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)activeButton, (double)finalDragX, (double)(finalDragY = dragY * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getHeight()))) {
                return;
            }
            if (screen.mouseDragged(finalMouseX, finalMouseY, activeButton, finalDragX, finalDragY)) {
                return;
            }
            ClientHooks.onScreenMouseDragPost((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)activeButton, (double)finalDragX, (double)finalDragY);
        }, (String)"Controllable mouseDragged event handler", (String)screen.getClass().getCanonicalName());
    }

    @Override
    public void sendScreenMouseClick(Screen screen, double mouseX, double mouseY, int button) {
        Screen.wrapScreenError(() -> {
            if (!ClientHooks.onScreenMouseClickedPre((Screen)screen, (double)mouseX, (double)mouseY, (int)button)) {
                boolean handled = screen.mouseClicked(mouseX, mouseY, button);
                ClientHooks.onScreenMouseClickedPost((Screen)screen, (double)mouseX, (double)mouseY, (int)button, (boolean)handled);
            }
        }, (String)"Controllable mouseClicked event handler", (String)screen.getClass().getCanonicalName());
    }

    @Override
    public void sendScreenMouseReleased(Screen screen, double mouseX, double mouseY, int button) {
        Screen.wrapScreenError(() -> {
            if (!ClientHooks.onScreenMouseReleasedPre((Screen)screen, (double)mouseX, (double)mouseY, (int)button)) {
                boolean handled = screen.mouseReleased(mouseX, mouseY, button);
                ClientHooks.onScreenMouseReleasedPost((Screen)screen, (double)mouseX, (double)mouseY, (int)button, (boolean)handled);
            }
        }, (String)"Controllable mouseReleased event handler", (String)screen.getClass().getCanonicalName());
    }

    @Override
    public List<GuiMessage.Line> getChatTrimmedMessages(ChatComponent chat) {
        return chat.trimmedMessages;
    }

    @Override
    public int getMinecraftFramerateLimit() {
        return Minecraft.getInstance().getFramerateLimit();
    }

    @Override
    public Slot getSlotUnderMouse(AbstractContainerScreen<?> screen) {
        return screen.getSlotUnderMouse();
    }

    @Override
    public int getAbstractListTop(AbstractSelectionList<?> list) {
        return list.getY();
    }

    @Override
    public int getAbstractListBottom(AbstractSelectionList<?> list) {
        return list.getBottom();
    }

    @Override
    public int getActiveMouseButton() {
        return Minecraft.getInstance().mouseHandler.activeButton;
    }

    @Override
    public void setActiveMouseButton(int button) {
        Minecraft.getInstance().mouseHandler.activeButton = button;
    }

    @Override
    public double getLastMouseEventTime() {
        return Minecraft.getInstance().mouseHandler.lastHandleMovementTime;
    }

    @Override
    public void setLastMouseEventTime(double time) {
        Minecraft.getInstance().mouseHandler.lastHandleMovementTime = time;
    }

    @Override
    public void startUseItem(Minecraft mc) {
        mc.startUseItem();
    }

    @Override
    public boolean startAttack(Minecraft mc) {
        return mc.startAttack();
    }

    @Override
    public void pickBlock(Minecraft mc) {
        mc.pickBlock();
    }

    @Override
    public List<Renderable> getScreenRenderables(Screen screen) {
        return screen.renderables;
    }

    @Override
    public int getScreenTop(AbstractContainerScreen<?> screen) {
        return screen.getGuiTop();
    }

    @Override
    public int getScreenLeft(AbstractContainerScreen<?> screen) {
        return screen.getGuiLeft();
    }

    @Override
    public void gatherCreativeTabNavigationPoints(CreativeModeInventoryScreen screen, List<NavigationPoint> points) {
        CreativeTabsScreenPage page = screen.getCurrentPage();
        page.getVisibleTabs().forEach(tab -> points.add(this.getCreativeTabPoint((AbstractContainerScreen<?>)screen, screen.getCurrentPage(), (CreativeModeTab)tab)));
    }

    @Override
    public boolean canLocalPlayerSwimInFluid(LocalPlayer player) {
        return !player.isInWater() && !player.isInFluidType((fluidType, height) -> player.canSwimInFluidType(fluidType)) || player.isUnderWater() || player.canStartSwimming();
    }

    @Override
    public void scrollCreativeTabs(CreativeModeInventoryScreen screen, int dir) {
        try {
            List pages = (List)ObfuscationReflectionHelper.getPrivateValue(CreativeModeInventoryScreen.class, (Object)screen, (String)"pages");
            if (pages != null) {
                if (dir > 0) {
                    screen.setCurrentPage((CreativeTabsScreenPage)pages.get(Math.min(pages.indexOf(screen.getCurrentPage()) + 1, pages.size() - 1)));
                } else if (dir < 0) {
                    screen.setCurrentPage((CreativeTabsScreenPage)pages.get(Math.max(pages.indexOf(screen.getCurrentPage()) - 1, 0)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public float getCreativeScrollOffset(CreativeModeInventoryScreen screen) {
        return ReflectUtil.getCreativeScrollOffset(screen);
    }

    @Override
    public void setCreativeScrollOffset(CreativeModeInventoryScreen screen, float offset) {
        ReflectUtil.setCreativeScrollOffset(screen, offset);
    }

    @Override
    public int getAbstractListRowBottom(AbstractSelectionList<?> list, int index) {
        return ReflectUtil.getAbstractListRowBottom(list, index);
    }

    @Override
    public int getAbstractListRowTop(AbstractSelectionList<?> list, int index) {
        return ReflectUtil.getAbstractListRowTop(list, index);
    }

    @Override
    public int getListItemHeight(AbstractSelectionList<?> list) {
        return ReflectUtil.getAbstractListItemHeight(list);
    }

    @Override
    public WidgetSprites getImageButtonResource(ImageButton btn) {
        return ReflectUtil.getImageButtonResource(btn);
    }

    @Override
    public void pushLinesToTooltip(Tooltip blank, List<FormattedCharSequence> lines) {
        ReflectUtil.pushLinesToTooltip(blank, lines);
    }

    @Override
    public int getKeyValue(KeyMapping mapping) {
        return mapping.getKey().getValue();
    }

    @Override
    public void setKeyPressTime(KeyMapping mapping, int time) {
        ReflectUtil.setKeyPressTime(mapping, time);
    }

    @Override
    public BindingContext createBindingContext(KeyMapping mapping) {
        return this.keyContextMap.computeIfAbsent(mapping.getKeyConflictContext(), NeoForgeKeyContext::new);
    }

    @Override
    public void sendKeyInputEvent(int key, int scanCode, int action, int modifiers) {
        ClientHooks.onKeyInput((int)key, (int)0, (int)action, (int)modifiers);
    }

    @Override
    public Component getOptionInstanceName(OptionInstance<Boolean> option) {
        return option.caption;
    }

    @Override
    public Tooltip getOptionInstanceTooltip(OptionInstance<Boolean> option) {
        return option.tooltip.apply((Object)true);
    }

    @Override
    public void openChatScreen(String s) {
        Minecraft.getInstance().openChatScreen(s);
    }

    @Override
    public int getStonecutterStartIndex(StonecutterScreen screen) {
        return ReflectUtil.getStonecutterStartIndex(screen);
    }

    @Override
    public int getLoomStartRow(LoomScreen screen) {
        return ReflectUtil.getLoomStartRow(screen);
    }

    private BasicNavigationPoint getCreativeTabPoint(AbstractContainerScreen<?> screen, CreativeTabsScreenPage page, CreativeModeTab tab) {
        int guiLeft = ClientServices.CLIENT.getScreenLeft(screen);
        int guiTop = ClientServices.CLIENT.getScreenTop(screen);
        boolean topRow = page.isTop(tab);
        int column = page.getColumn(tab);
        int width = 28;
        int height = 32;
        int x = guiLeft + width * column;
        int y = guiTop;
        x = tab.isAlignedRight() ? guiLeft + screen.getXSize() - width * (6 - column) : (column > 0 ? x + column : x);
        y = topRow ? y - width : y + (screen.getYSize() - 4);
        return new BasicNavigationPoint((double)x + (double)width / 2.0, (double)y + (double)height / 2.0);
    }
}

